%define ver_major 0.10
%define api_ver 0.10
%define _name goffice

%def_with lasem
%def_enable introspection
%ifarch %ix86 ppc64le
%def_disable check
%endif

Name: libgnomeoffice%api_ver
Version: %ver_major.53
Release: alt1

Summary: Library for writing gnome office programs
Group: Graphical desktop/GNOME
License: GPL-2.0 or GPL-3.0
Url: http://www.gnumeric.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define glib_ver 2.28.0
%define gsf_ver 1.14.47
%define gtk_ver 3.0.0
%define cairo_ver 1.10.0
%define lasem_ver 0.4.1

BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgsf-devel >= %gsf_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libcairo-devel >= %cairo_ver
BuildRequires: libgs-devel
BuildRequires: libXext-devel libXrender-devel libxml2-devel libxslt-devel librsvg-devel
BuildRequires: intltool gtk-doc
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgsf-gir-devel libgtk+3-gir-devel}
%{?_with_lasem:BuildRequires: liblasem-devel >= %lasem_ver}

%description
GOffice is a library that eases the task of writing gnome office
programs.

%package devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains the header files and libraries needed to write and
compile programs that use %name.

%package devel-doc
Summary: Development documentation for Goffice
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package contains development documentation for Goffice library.

%package gir
Summary: GObject introspection data for the Goffice library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Goffice library.

%package gir-devel
Summary: GObject introspection devel data for the Goffice library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the Goffice library.


%define _libexecdir %_libdir/%name

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure \
	--with-config-backend=gsettings \
	%{subst_with lasem} \
	%{?_enable_introspection:--enable-introspection=yes}
%nil
%make_build

%install
%makeinstall_std

%find_lang --output=%_name.lang %_name-%version

%check
%make check

%files -f %_name.lang
%_libdir/*.so.*
%dir %_libdir/goffice
%dir %_libdir/goffice/%version
%dir %_libdir/goffice/%version/plugins
%_libdir/goffice/%version/plugins/plot_barcol/
%_libdir/goffice/%version/plugins/plot_distrib/
%_libdir/goffice/%version/plugins/plot_pie/
%_libdir/goffice/%version/plugins/plot_radar/
%_libdir/goffice/%version/plugins/plot_surface/
%_libdir/goffice/%version/plugins/plot_xy/
%_libdir/goffice/%version/plugins/reg_linear/
%_libdir/goffice/%version/plugins/reg_logfit/
%_libdir/goffice/%version/plugins/smoothing/
%_libdir/goffice/%version/plugins/lasem/
%dir %_datadir/goffice
%dir %_datadir/goffice/%version
%_datadir/goffice/%version/mmlitex/
%doc AUTHORS NEWS README

%exclude %_libdir/%_name/%version/plugins/*/*.la

%files devel
%_includedir/libgoffice-%api_ver/
%_libdir/*.so
%_libdir/pkgconfig/*

%files devel-doc
%_datadir/gtk-doc/html/%_name-%api_ver/

%if_enabled introspection
%files gir
%_typelibdir/GOffice-%api_ver.typelib

%files gir-devel
%_girdir/GOffice-%api_ver.gir
%endif


%changelog
