%define _unpackaged_files_terminate_build 1

%define realname gtk-sharp
%def_disable doc

Summary: GTK+ and GNOME bindings for Mono
Name: lib%{realname}2
Version: 2.12.45
Release: alt1
License: LGPLv2+
Group: Development/Other
Url: http://www.mono-project.com/

# https://github.com/mono/gtk-sharp.git
Source: %name-%version.tar

Patch1: 0001-apply-gtk-sharp-2.10.1-fix-configs.patch.patch
Patch2: 0002-apply-gtk-sharp-2.12.6-alt-monodoc.patch.patch

# Patches from Fedora
Patch10: gtk-sharp2-2.12.12-glib-include.patch
Patch11: gtk-sharp2-2.12.12-gtkrange.patch

Requires: libglade libgtk+2 >= 2.12.0

BuildPreReq: glib2-devel >= 2.12.0
BuildPreReq: libpango-devel
BuildPreReq: libatk-devel
BuildPreReq: libgtk+2-devel >= 2.12.0
BuildPreReq: libglade-devel >= 2.3.6
BuildPreReq: rpm-build-mono perl-XML-LibXML

BuildRequires: gcc-c++ mono-devel 
%{?_enable_doc:BuildRequires: mono-monodoc-devel}
BuildRequires: /proc

Conflicts: lib%{realname}2-mono4
Obsoletes: lib%{realname}2-mono4
Provides: lib%{realname}2-mono4 = %EVR

%description
This package provides a library that allows you to build
fully native graphical GNOME applications using Mono. Gtk#
is a binding to GTK+, the cross platform user interface
toolkit used in GNOME. It includes bindings for Gtk, Atk,
Pango, Gdk, libgnome, libgnomeui and libgnomecanvas. Gtk#
2.10.x binds GTK+ 2.10.

%package gapi
Summary: Glib and GObject C source parser and C generator for the creation and maintenance of managed bindings for Mono and .NET
Group: Development/Other
Requires: %name = %EVR
Provides: lib%{realname}2-mono4-gapi = %EVR
Conflicts: lib%{realname}2-mono4-gapi
Obsoletes: lib%{realname}2-mono4-gapi

%description gapi
This package provides developer tools for the creation and
maintainance of managed bindings to native libraries which utilize
glib and GObject. Some examples of libraries currently bound using
the GAPI tools and found in Gtk# include Gtk, Atk, Pango, Gdk,
libgnome, libgnomeui and libgnomecanvas.

%package devel
Summary: .Net language bindings for Gtk+ and GNOME development files
Group: Development/Other
Requires: %name-gapi = %EVR
Provides: lib%{realname}2-mono4-devel = %EVR
Conflicts: lib%{realname}2-mono4-devel
Obsoletes: lib%{realname}2-mono4-devel

%description devel
This package includes development files for the Gtk\# project
to parse and bind GObject libraries.

%package doc
Summary: %name documentation in monodoc format
Group: Documentation
Provides: %name-monodoc = %EVR
Obsoletes: %name-monodoc
Provides: %name-mono4-monodoc = %EVR
Obsoletes: %name-mono4-monodoc
Requires: mono-monodoc >= 2.2
BuildArch: noarch
Obsoletes: lib%{realname}2-mono4-doc
Provides: lib%{realname}2-mono4-doc = %EVR
Conflicts: lib%{realname}2-mono4-doc

%description doc
This package includes documentation in monodoc format for the Gtk\# project
for use with monodoc / monodoc Gtk# (from mono-tools) / monodevelop.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch10 -p1
%patch11 -p1

%build
NOCONFIGURE=1 ./bootstrap-2.12
%configure --disable-static
%make

%install
%make_install DESTDIR=%buildroot install

%files
%doc README COPYING ChangeLog
%prefix/lib/gtk-sharp-2.0
%exclude %prefix/lib/gtk-sharp-2.0/gapi*
%_monodir/gac/*
%_monodir/gtk-sharp-2.0
%_libdir/*.so
%_pkgconfigdir/*
%exclude %_pkgconfigdir/gapi-2.0.pc

%files gapi
%_bindir/gapi2*
%prefix/lib/gtk-sharp-2.0/gapi*
%dir %_datadir/gapi-2.0

%files devel
%_datadir/gapi-2.0/*.xml
%_pkgconfigdir/gapi-2.0.pc

%if_enabled doc
%files doc
%_monodocdir/*
%endif

%changelog
