%define _name gupnp-av
%define ver_major 0.13
%define api_ver 1.0

%def_enable introspection
%def_enable vala
%def_enable gtk_doc

Name: libgupnp-av
Version: %ver_major.0
Release: alt1

Summary: A library to handle UPnP A/V profiles
Group: System/Libraries
License: LGPL-2.1
Url: http://www.gupnp.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires(pre): meson
BuildRequires: glib2-devel >= 2.58 libxml2-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}

%description
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

GUPnP A/V is a small utility library that aims to ease the handling and
implementation of UPnP A/V profiles

%package devel
Summary: Development files and libraries for gUPnP-IGD
Group: Development/C
Requires: %name = %EVR

%description devel
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

GUPnP A/V is a small utility library that aims to ease the handling and
implementation of UPnP A/V profiles.
This package provides files for development with gUPnP-AV.

%package devel-doc
Summary: Development documentaion for gUPnP-AV
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

GUPnP A/V is a small utility library that aims to ease the handling and
implementation of UPnP A/V profiles.
This package provides development documentations for gUPnP-AV.

%package gir
Summary: GObject introspection data for the GUPnP A/V library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GUPnP A/V library

%package gir-devel
Summary: GObject introspection devel data for the GUPnP A/V library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the GUPnP A/V library


%prep
%setup -n %_name-%version

%build
%meson \
%{?_disable_introspection:-Dintrospection=false} \
%{?_disable_vala:-Dvapi=false} \
%{?_enable_gtk_doc:-Dgtk_doc=true}
%nil
%meson_build

%check
%meson_test

%install
%meson_install

%files
%_libdir/*.so.*
%doc AUTHORS README* NEWS
%_datadir/%_name

%files devel
%_pkgconfigdir/*
%_libdir/*.so
%_includedir/*
%{?_enable_vala:%_vapidir/*.deps
%_vapidir/*.vapi}

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files gir
%_typelibdir/GUPnPAV-%api_ver.typelib

%files gir-devel
%_girdir/GUPnPAV-%api_ver.gir
%endif


%changelog
