%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 40
%define beta %nil
%define api_ver 3.0
%def_enable introspection
%def_enable vala
%def_enable gtk_doc
%def_enable glade
# fails offline
%def_disable check

Name: libgweather
Version: %ver_major.0
Release: alt1%beta

Summary: A library for weather information
Group: System/Libraries
License: GPLv3
Url: https://wiki.gnome.org/Projects/LibGWeather

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define gtk_ver 3.13.5
%define glib_ver 2.44
%define soup_ver 2.44
%define gir_ver 0.9.5
%define vala_ver 0.21.1
%define geocode_ver 3.26.1

Requires: %name-data = %EVR

BuildRequires(pre): rpm-build-gnome meson
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libgeocode-glib-devel >= %geocode_ver libxml2-devel
BuildRequires: xsltproc perl-XML-Parser xml-utils gzip
BuildRequires: python3-module-pygobject3 python3-module-pylint
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gir_ver libgtk+3-gir-devel}
%{?_enable_vala:BuildRequires: vala-tools >= %vala_ver}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_glade:BuildRequires: libgladeui2.0-devel}

%description
libgweather is a library to access weather information from online
services for numerous locations.

%package data
Summary: Locations data for %name
Group: System/Libraries
BuildArch: noarch

%description data
libgweather is a library to access weather information from online
services for numerous locations.

This package contains locations data for %name

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %EVR

%description devel-doc
The %name-devel-doc package contains documentation for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name library

%package gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the %name library

%package vala
Summary: Vala language bindings for the %name library
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %EVR

%description vala
This package provides Vala language bindings for the %name library.

%prep
%setup -n %name-%version%beta

sed -i "s|'\(pylint\)'|'\1.py3'|" meson.build

%build
# for tm.tm_gmtoff
%add_optflags -D_GNU_SOURCE
%meson \
    %{?_enable_gtk_doc:-Dgtk_doc=true} \
    %{?_disable_vala:-Denable_vala=false} \
    %{?_disable_glade:-Dglade_catalog=false}
%meson_build

%install
%meson_install
%find_lang --output=%name.lang %name-%api_ver
%find_lang --output=%name-locations.lang %name-locations

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%dir %_libdir/%name
%_libdir/%name/Locations.bin
%_libdir/*.so.*
%_datadir/glib-2.0/schemas/org.gnome.GWeather.enums.xml
%_datadir/glib-2.0/schemas/org.gnome.GWeather.gschema.xml
%doc AUTHORS NEWS README*

%files data -f %name-locations.lang
%dir %_datadir/libgweather
%_datadir/libgweather/Locations.xml
%_datadir/libgweather/locations.dtd

%files devel
%_includedir/%name-%api_ver
%_libdir/*.so
%_pkgconfigdir/*
%{?_enable_glade:%_datadir/glade/catalogs/%name.xml}

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files gir
%_typelibdir/GWeather-%api_ver.typelib

%files gir-devel
%_girdir/GWeather-%api_ver.gir
%endif

%if_enabled vala
%files vala
%_vapidir/gweather-%api_ver.vapi
%_vapidir/gweather-%api_ver.deps
%endif


%changelog
