Name: libidn
Version: 1.37
Release: alt1

Summary: Internationalized Domain Name support library
Group: System/Libraries
License: LGPLv3+/GPLv2+ and GPLv3+ and GFDL
Url: http://www.gnu.org/software/%name/
# ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
Source: %name-%version.tar

%def_enable java
%def_with emacs
%{?!_without_emacs:BuildRequires: emacs-devel emacs-nox}

%description
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

%package devel
Group: Development/C
Summary: Development files for the %name library
Requires: %name = %version-%release

%description devel
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

This package includes headers and other development files necessary
for developing programs which use the GNU Libidn library.

%package devel-doc
Summary: Development documentation for the %name library
Group: Development/C
License: GFDL
Requires: %name-devel = %version-%release
BuildArch: noarch

%description devel-doc
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

This package contains %name development documentation.

%package -n emacs-%name
Summary: GNU Emacs %name support files
Group: Development/Other
License: GPLv3+
BuildArch: noarch

%description -n emacs-%name
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

This package includes %name support files for GNU Emacs.

%if_enabled java
%package java
Group: Development/Java
Summary:       Java port of the GNU Libidn library
BuildRequires(pre): rpm-macros-java
BuildRequires: rpm-build-java java-devel-default javapackages-local
BuildRequires: mvn(com.google.code.findbugs:annotations)
BuildRequires: mvn(com.google.guava:guava)
BuildRequires: mvn(junit:junit)
BuildArch:     noarch

%description java
GNU Libidn is a fully documented implementation of the Stringprep,
Punycode and IDNA specifications. Libidn's purpose is to encode
and decode internationalized domain names.

This package contains the native Java port of the library.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}-java
BuildArch:     noarch

%description javadoc
This package contains javadoc for %{name}-java.
%endif

%prep
%setup

%if_enabled java
# Cleanup
find . -name '*.jar' -print -delete
find . -name '*.class' -print -delete

# Not available test dep
%pom_remove_dep com.google.caliper:caliper java/pom.xml.in
%endif

%build
#%%autoreconf
%configure \
	%{subst_enable java} \
	--disable-rpath \
	--disable-static \
	--disable-silent-rules \
	#

# remove RPATH hardcoding
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

# without RPATH this needs to be set for idn executed by help2man
export LD_LIBRARY_PATH=$(pwd)/lib/.libs

%make_build

%install
%makeinstall_std \
%if_enabled java
 libidn_jardir=%{_javadir}
%endif

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -fnrs %buildroot/%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

rm %buildroot%_infodir/*.png
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir/reference/html
install -pm644 doc/*.pdf %buildroot%docdir/
install -pm644 AUTHORS COPYING FAQ NEWS README THANKS %buildroot%docdir/
install -pm644 doc/reference/*.pdf %buildroot%docdir/reference/
install -pm644 doc/reference/html/* %buildroot%docdir/reference/html/

%if_enabled java
# regenerate java documentation (breaks %%check)
##rm -rf doc/java/*
##find doc/java -name '*.html' -delete
##%javadoc -source 1.6 -d doc/java $(find java/src/main/java -name "*.java")
# generate maven depmap
rm -rf $RPM_BUILD_ROOT%{_javadir}/libidn*.jar
%mvn_artifact java/pom.xml java/libidn-%{version}.jar
%mvn_file org.gnu.inet:libidn libidn
%mvn_install -J doc/java
%endif

%find_lang %name
%set_verify_elf_method strict
%if_with emacs
%define _unpackaged_files_terminate_build 1
%endif

%check
export LD_LIBRARY_PATH=%buildroot/%_lib:%buildroot%_libdir
%make_build check VERBOSE=1

%files -f %name.lang
/%_lib/*.so.*
%_bindir/idn
%_man1dir/*
%dir %docdir
%docdir/[ACFNRT]*

%files devel
%_libdir/*.so
%_includedir/*.h
%_pkgconfigdir/*.pc
%_man3dir/*
%_infodir/*

%files devel-doc
%dir %docdir/
%docdir/*.pdf
%docdir/reference/

%if_with emacs
%files -n emacs-%name
%_emacslispdir/*
%endif #emacs

%if_enabled java
%files java -f .mfiles
%doc COPYING* java/LICENSE-2.0.txt

%files javadoc -f .mfiles-javadoc
%doc COPYING* java/LICENSE-2.0.txt
%endif #java

%changelog
