%def_disable static

%define title jemalloc
%define sorev 2

Name: libjemalloc2
Version: 5.2.1
Release: alt1
Summary: A general-purpose scalable concurrent malloc(3) implementation
Group: System/Libraries
License: BSD
Url: http://jemalloc.net/

Source: %title-%version.tar

# Automatically added by buildreq on Mon May 14 2018
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libstdc++-devel python-base
BuildRequires: gcc-c++
BuildRequires: xsltproc docbook-style-xsl

%description
jemalloc is a general-purpose scalable concurrent malloc(3)
implementation. There are several divergent versions of jemalloc in
active use, including:

 * FreeBSD's default system allocator (malloc.c, manual page). This was
    the first public use of jemalloc, and it is still author-maintained.
 * NetBSD's default system allocator (jemalloc.c).
 * Mozilla Firefox's allocator (source code), specifically for
   Microsoft Windows-related platforms, Solaris, and Linux. There is
   Apple Mac OS X support code as well, but it has never been used in a
   release.
 * The stand-alone jemalloc, which currently targets only Linux.
   Thus far I have had no driving need to integrate support for other
   operating systems into this version of jemalloc, but it is probable
   that the stand-alone jemalloc library's platform support will
    broaden over time.

%package -n libjemalloc-tools
Summary: Shell wrapper  for preloading %title
Group: System/Libraries
License: BSD
Requires: %name = %EVR

%description -n libjemalloc-tools
Starting up wrapper for use %title.

%package -n libjemalloc-devel
Summary: Development files, debugging and profiling version of %title
Group: System/Libraries
License: BSD

%description -n libjemalloc-devel
Development files, debugging and profiling version of %title

%prep
%setup -n %title-%version
# XXX hack out "restrict keyword"
##for f in `fgrep -rl '*restrict ' .`; do sed -i 's/\*restrict /\*/g' $f; done

%build
CONF="--enable-swap --enable-xmalloc --enable-dss --enable-sysv --enable-autogen --enable-log --enable-utrace --with-xslroot=/usr/share/xml/docbook/xsl-stylesheets"
%configure $CONF --enable-debug
%make_build
%make doc
mkdir -p debug
cp -a lib/lib* debug
%configure $CONF --enable-prof --enable-stats
%make_build install_suffix=_profiler
mkdir -p prof
cp -a lib/lib* prof
%configure $CONF
%make_build

%install
%makeinstall DESTDIR=%buildroot
mkdir -p %buildroot%_libdir/debug %buildroot%_libdir/prof
cp -a debug/* %buildroot%_libdir/debug
cp -a prof/* %buildroot%_libdir/

#mv %buildroot%_bindir/pprof %buildroot%_bindir/pprof.%title
mv %buildroot%_defaultdocdir/jemalloc %buildroot%_defaultdocdir/jemalloc%sorev

# add so.2 -> so.2.0
mv %buildroot%_libdir/libjemalloc.so.%sorev %buildroot%_libdir/libjemalloc.so.%sorev.0
ln -s libjemalloc.so.%sorev.0 %buildroot%_libdir/libjemalloc.so.%sorev
mv %buildroot%_libdir/libjemalloc_profiler.so.%sorev %buildroot%_libdir/libjemalloc_profiler.so.%sorev.0
ln -s libjemalloc_profiler.so.%sorev.0 %buildroot%_libdir/libjemalloc_profiler.so.%sorev

%if_disabled static
rm -rf %buildroot%_libdir/debug/*.a %buildroot%_libdir/*.a
%endif

%files
%doc %_defaultdocdir/jemalloc2
%doc COPYING README TUNING* VERSION
%_libdir/libjemalloc.so.%sorev
%_libdir/libjemalloc.so.%sorev.0

%files -n libjemalloc-tools
%_bindir/jemalloc.sh

%files -n libjemalloc-devel
%_bindir/*prof
%_includedir/*
%_man3dir/*
%_libdir/libjemalloc.so
%_libdir/libjemalloc_profiler.so*
%if_enabled static
%_libdir/lib*.a
%endif
%_libdir/debug/lib*
%_bindir/*config
%_pkgconfigdir/*.pc

%changelog
