%define _libexecdir %_prefix/libexec

%define _name json-glib
%define ver_major 1.6
%define api_ver 1.0
%def_disable gtk_doc
%def_enable man
%def_enable introspection
%def_enable check

Name: lib%_name
Version: %ver_major.4
Release: alt1

Summary: GLib-based JSON manipulation library
Group: System/Libraries
License: LGPLv2.1
Url: https://wiki.gnome.org/Projects/JsonGlib

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

# https://gitlab.gnome.org/GNOME/json-glib/-/issues/33
# --default-symver breaks set-versioned dependencies, revert it
Patch: json-glib-1.6.4-alt-remove_symbol_versioning.patch

%define glib_ver 2.54
%define gi_ver 0.10.5

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson glib2-devel >= %glib_ver
%{?_enable_static:BuildRequires: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}

%description
JSON-GLib implements a full JSON parser using GLib and GObject. Use
JSON-GLib it is possible to parse and generate valid JSON data
structures, using a DOM-like API. JSON-GLib also offers GObject
integration, providing the ability to serialize and deserialize GObject
instances to and from JSON data types.

%package devel
Summary: Development files for %_name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the JSON-GLib library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the JSON-GLib library

%package gir-devel
Summary: GObject introspection devel data for the JSON-GLib library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the JSON-GLib library

%package devel-doc
Summary: Development package for JSON-GLib
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description devel-doc
This package contains developer documentation for the JSON-GLib library.

%package tests
Summary: Tests for the %_name package
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %_name library.


%prep
%setup -n %_name-%version
%patch -p1 -b .symver

%build
%meson %{?_disable_introspection:-Dintrospection=disabled} \
	%{?_disable_gtk_doc:-Dgtk_doc=disabled} \
	%{?_enable_man:-Dman=true}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%_name.lang %_name-%api_ver

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %_name.lang
%_bindir/%_name-format
%_bindir/%_name-validate
%_libdir/*.so.*
%if_enabled man
%_man1dir/%_name-format.1.*
%_man1dir/%_name-validate.1.*
%endif
%doc NEWS README.md

%files devel
%_libdir/*.so
%_includedir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc

%if_enabled introspection
%files gir
%_typelibdir/Json-%api_ver.typelib

%files gir-devel
%_girdir/Json-%api_ver.gir
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name
%endif

%files tests
%_libexecdir/installed-tests/%_name-%api_ver/
%_datadir/installed-tests/%_name-%api_ver/

%changelog
