Name: libksba
Version: 1.6.3
Release: alt1

Group: System/Libraries
Summary: X.509 library
URL: https://www.gnupg.org/
License: (LGPL-3.0-or-later OR GPL-2.0-or-later) AND GPL-3.0-or-later AND MIT

Source0: %name-%version.tar
Patch1: %{name}-info.patch
Patch2: 0002-Fix-LFS-on-32-bit-systems.patch
Patch3: 0003-ALT-version-is-not-beta.patch

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%set_verify_elf_method strict

BuildRequires: gcc-c++
BuildRequires: pkgconfig(libgcrypt)
BuildRequires: pkgconfig(gpg-error)
BuildRequires: makeinfo

%description
KSBA is a library designed to build software based
on the X.509 and CMS protocols.

%package -n %name-devel
Summary: Development files for the %name package
Group: Development/Other
Requires: %name = %version-%release
%description -n %name-devel
Development files for the %name package

%prep
%setup -q
%autopatch -p1

cat > doc/version.texi <<EOF
@set UPDATED $(LANG=C date -u -r doc/ksba.texi +'%%d %%B %%Y')
@set UPDATED-MONTH $(LANG=C date -u -r doc/ksba.texi +'%%B %%Y')
@set EDITION %version
@set VERSION %version
EOF

%build
%autoreconf
%configure \
    --enable-ld-version-script
%make_build

%install
%makeinstall_std

%check
%make_build check

%files
%doc AUTHORS NEWS README
%_libdir/*.so.*

%files -n %name-devel
%_bindir/ksba-config
%_aclocaldir/*
%_includedir/*.h
%_libdir/*.so
%_pkgconfigdir/ksba.pc
%_infodir/*.info*

%changelog
