%define rname lcms
%define major 1
%define minor 19
%define beta %nil

Name: lib%rname
Version: %major.%minor
Release: alt5

Summary: Little cms color engine
License: LGPL
Group: System/Libraries
Url: http://www.littlecms.com

Provides: %rname = %version
Obsoletes: %rname < %version


Source: %rname-%version.tar.gz
Source1: %rname-compat.map
Source2: %rname-compat.lds
Patch1: liblcms-1.19-alt-fix-linking.patch

# Automatically added by buildreq on Tue Feb 15 2011
BuildRequires: libjpeg-devel libtiff-devel zlib-devel


%package devel
Summary: LCMS development environment
Group: Development/C
Requires: %name = %version-%release
Provides: lcms-devel = %version
Obsoletes: lcms-devel < %version

%package devel-static
Summary: Static LCMS library
Group: Development/C
Requires: %name-devel = %version-%release

%package -n lcms-utils
Summary: Various %name-based utilities
Group: Graphics
Requires: %name = %version-%release

%description
This is a CMM engine to deal with color management stuff.

This package contains the library needed to run programs dynamically
linked with %name.

%description devel
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
applications which requires the LCMS library.

%description devel-static
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
statically linked applications which requires the LCMS library.

%description -n lcms-utils
This is a CMM engine to deal with color management stuff.

This package contains various %name-based utilities

%prep
%setup -q -n %rname-%version
%patch1 -p1
sed -i "s|^LIBRARY_CURRENT=.*$|LIBRARY_CURRENT=%major|" configure.ac
sed -i "s|^LIBRARY_REVISION=.*$|LIBRARY_REVISION=%minor|" configure.ac
find . -type f -exec chmod -x {} ';'
chmod a+x ./configure
r=$(echo -e \\r)
sed -i "s/$r//g;s/^AC_PROG_CXX//;s,python/Makefile,," configure.ac
sed -i "s/ python / /" Makefile.am
autoreconf -fisv

%build
%configure --without-python --includedir=%_includedir/lcms

# SMP-incompatible
%make -C src LDFLAGS='-Wl,--version-script=%_sourcedir/%rname-compat.map -Wl,%_sourcedir/%rname-compat.lds'
%make

%install
#makeinstall includedir=%buildroot/%_includedir/lcms
%make install DESTDIR=%buildroot

pushd %buildroot/%_includedir/lcms
for f in *
do
    ln -s lcms/$f ../$f
done
popd


%files
%doc AUTHORS NEWS README*
%_libdir/*.so.*


%files -n lcms-utils
%_bindir/*
%_man1dir/*

%files devel
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*

%files devel-static
%_libdir/*.a

%changelog
