%def_disable snapshot
%def_disable static
%def_enable check

%define rname lcms2

Name: lib%rname
Version: 2.12
Release: alt2

Summary: Little cms color engine, version 2
License: MIT
Group: System/Libraries
Url: http://www.littlecms.com

%if_disabled snapshot
Source: http://downloads.sourceforge.net/lcms/%rname-%version.tar.gz
%else
Vcs: https://github.com/mm2/Little-CMS.git
Source: %rname-%version.tar
%endif

# Automatically added by buildreq on Sat Nov 06 2010
BuildRequires: gcc-c++ libjpeg-devel libtiff-devel zlib-devel

%package devel
Summary: LCMS 2 development environment
Group: Development/C
Requires: %name = %version-%release

%if_enabled static
%package devel-static
Summary: Static LCMS 2 library
Group: Development/C
Requires: %name-devel = %version-%release
%endif

%package -n lcms2-utils
Summary: Various %name-based utilities
Group: Graphics
Requires: %name = %version-%release

%description
This is a CMM engine to deal with color management stuff.

This package contains the library needed to run programs dynamically
linked with %name.

%description devel
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
applications which requires the LCMS 2 library.

%if_enabled static
%description devel-static
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
statically linked applications which requires the LCMS 2 library.
%endif

%description -n lcms2-utils
This is a CMM engine to deal with color management stuff.

This package contains various %name-based utilities

%prep
%setup -n %rname-%version

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
	%{subst_enable static}
%nil
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/%name.so.*
%doc AUTHORS README* COPYING

%files -n lcms2-utils
%_bindir/jpgicc
%_bindir/linkicc
%_bindir/psicc
%_bindir/tificc
%_bindir/transicc
%_man1dir/*

%files devel
%_includedir/*
%_libdir/%name.so
%_pkgconfigdir/%rname.pc

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
