Name:    libleatherman
Version: 1.12.6
Release: alt1
Summary: A collection of C++ and CMake utility libraries
 
Group:   System/Libraries
License: Apache-2.0
Url:     https://github.com/puppetlabs/leatherman
Packager: Andrey Cherepanov <cas@altlinux.org>
 
Source: leatherman-%version.tar
Patch1: fedora-shared_nowide.patch
 
BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: boost-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-locale-devel
BuildRequires: boost-log-devel
BuildRequires: libcurl-devel

%description
A collection of C++ and CMake utility libraries.

%package devel
Summary: cpp-hocon development headers
Group: Development/Other
Provides: leatherman-devel = %version-%release
Obsoletes: leatherman-devel < %version-%release
Requires: boost-locale-devel

%description devel
Development headers for leatherman.

%add_python3_path %_libdir/cmake/leatherman/scripts/

%prep
%setup -n leatherman-%version
%patch1 -p1
# Ruby 2.3 fix: replace rb_data_object_alloc symbol with rb_data_object_wrap
sed -i 's/rb_data_object_alloc/rb_data_object_wrap/g' \
	$( grep -rl rb_data_object_alloc ruby )
%ifarch %e2k
# actually any EDG-based compiler (up to and including 5.0 it seems);
# see also http://bugs.webkit.org/show_bug.cgi?id=29034 and mcst#5101
sed -r -i.orig 's,reinterpret_cast<char\*\*\*>,(char***),g' ruby/src/api.cc
%endif
# Set correct python executable in shebang
subst 's|#!.*python$|#!%__python3|' scripts/cpplint.py

%build
%cmake -GNinja \
       -DLEATHERMAN_SHARED=TRUE \
       -DENABLE_CXX_WERROR=OFF
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"

%files
%doc *.md
%_libdir/leatherman_*.so.*
%_datadir/locale/*/LC_MESSAGES/leatherman_*.mo

%files devel
%_libdir/leatherman_*.so
%_includedir/leatherman
%_libdir/cmake/leatherman

%changelog
