%define git %nil

Name: libopus
Version: 1.4
Release: alt1

Summary: Opus Audio Codec library
License: BSD
Group: System/Libraries
Url: http://opus-codec.org/
# http://downloads.xiph.org/releases/opus/%name-%version.tar.gz
Source: opus-%version.tar
Patch: libopus-silk-fix-missing-have_arm_intrinsics_or_asm.patch

BuildRequires(pre): meson, cmake

%def_disable static

%description
The Opus codec is designed for interactive speech and audio transmission
over the Internet. It is designed by the IETF Codec Working Group and
incorporates technology from Skype's SILK codec and Xiph.Org's CELT codec.

%package devel
Summary: Development files for libopus
Group: Development/C
PreReq: %name = %version-%release
BuildRequires: doxygen, graphviz, fonts-ttf-dejavu

%description devel
This package contains the header files and documentation needed
to develop applications with libopus.

%package devel-static
Summary: Static libraries for libopus
Group: Development/C
PreReq: %name-devel = %version-%release

%description devel-static
This package contains development libraries required for packaging
statically linked libopus-based software.

%prep
%setup -n opus-%version
%patch -p2

%build
printf 'PACKAGE_VERSION="%s"\n' '%version' > package_version
%meson -Dintrinsics=auto \
       -Dcheck-asm=true \
%ifarch x86_64
       -Drtcd=disabled
%endif
%meson_build

%install
%meson_install

%check
%__meson_test -t 1000

%files
%_libdir/*.so.*
%doc AUTHORS README COPYING LICENSE_PLEASE_READ.txt

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%dir %_docdir/opus/
%_docdir/opus/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
