%define _unpackaged_files_terminate_build 1

Name: libowfat
Version: 0.32
Release: alt1
Summary: Reimplementation of libdjb
License: GPLv2
Group: System/Libraries
Url: http://www.fefe.de/libowfat/

Source: %name-%version.tar
Patch0: %name-%version-alt-build-flags.patch
Patch1: %name-%version-alt-no-dietlibc.patch
Patch2: %name-%version-alt-no-man.patch
Patch3: %name-%version-debian-fix-gcc10.patch
Patch4: %name-%version-alt-fno-common.patch

%package devel
Summary: Headers and static lib for libowfat development
Group: Development/C
Requires: %name = %EVR

%description
This library is a reimplementation of libdjb, which means that it provides
Daniel Bernstein's interfaces (with some extensions).

It contains wrappers around memory allocation, buffered I/O, routines for
formatting and scanning, a full DNS resolver, several socket routines,
wrappers for socket functions, mkfifo, opendir, wait, and an abstraction
around errno.  It also includes wrappers for Unix signal functions and a
layer of mmap and sendfile.

%description devel
Install this package if you want do compile applications using the
%name library.

%prep
%setup
%patch0 -p2
%patch1 -p2
%patch2 -p2
%patch3 -p1
%patch4 -p2

%build
%add_optflags %optflags_shared

%make -f GNUmakefile \
        havescope.h \
        CFLAGS="%optflags" \
        %nil

%make_build -f GNUmakefile \
        CFLAGS="%optflags" \
        %nil

%install
%add_optflags %optflags_shared

make -f GNUmakefile install \
        prefix="%buildroot%prefix" \
        LIBDIR="%buildroot%_libdir" \
        INCLUDEDIR="%buildroot%_includedir/%name" \
        CFLAGS="%optflags" \
        %nil

ln -s libowfat.so.%version %buildroot%_libdir/libowfat.so.0
ln -s libowfat.so.0 %buildroot%_libdir/libowfat.so

%files
%doc README TODO COPYING CHANGES
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_includedir/%name/

%changelog
