%define uname physfs
Name: libphysfs
Version: 3.0.2
Release: alt1

Summary: PhysicsFS file abstraction layer for games
License: zlib license
Group: System/Libraries
Url: http://www.icculus.org/physfs/
Provides: %uname = %version
Source0: http://icculus.org/physfs/downloads/physfs-%version.tar.gz

# Automatically added by buildreq on Sat Oct 24 2009
BuildRequires: doxygen gcc-c++ libncurses-devel libreadline-devel zlib-devel cmake

%description
PhysicsFS is a library to provide abstract access to various archives.
It is intended for use in video games, and the design was somewhat inspired
by Quake 3's file subsystem. The programmer defines a "write directory" on
the physical filesystem. No file writing done through the PhysicsFS API can
leave that write directory, for security. For example, an embedded scripting
language cannot write outside of this path if it uses PhysFS for all of its
I/O, which means that untrusted scripts can run more safely. Symbolic links
can be disabled as well, for added safety. For file reading, the programmer
lists directories and archives that form a "search path". Once the search
path is defined, it becomes a single, transparent hierarchical filesystem.
This makes for easy access to ZIP files in the same way as you access a file
directly on the disk, and it makes it easy to ship a new archive that will
override a previous archive on a per-file basis. Finally, PhysicsFS gives
you platform-abstracted means to determine if CD-ROMs are available, the
user's home directory, where in the real filesystem your program is running,
etc.

%package devel
Summary: Development headers, libraries, and documentation for PhysicsFS
Group: Development/C
Requires: %name = %version-%release
Provides: %uname-devel = %version

%description devel
PhysicsFS is a library to provide abstract access to various archives.
This package contains the development headers, libraries, and documentaion to
build programs using PhysicsFS.

%prep
%setup -n %uname-%version

%build
%cmake_insource \
	-DPHYSFS_BUILD_STATIC:BOOL=OFF

%make_build

doxygen

%install
%makeinstall_std

%files
%doc docs/CHANGELOG.txt docs/CREDITS.txt docs/INSTALL.txt LICENSE.txt docs/TODO.txt
%_libdir/*so.*[0-9]

%files devel
%_bindir/test_physfs
%doc docs/*
%_libdir/*.so
%_libdir/pkgconfig/physfs.pc
%_includedir/physfs.h

%changelog
