# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# API version for libpreludedb
%global major                   7
# API version for libpreludedb c++ binding
%global cppmajor                2

Name:           libpreludedb
Version:        5.1.0
Release:        alt1_2
Summary:        Framework for easy access to the IDMEF database
# Prelude is GPL-2.0+
# libmissing is LGPL-2.1+
License:        GPLv2+
URL:            https://www.prelude-siem.org/
Source0:        https://www.prelude-siem.org/pkg/src/%{version}/%{name}-%{version}.tar.gz
# https://www.prelude-siem.org/issues/867
Patch0:         libpreludedb-5.1.0-undefined_non_weak_symbol.patch
Patch1:         libpreludedb-5.1.0-fix_py38.patch
Patch2:         libpreludedb-5.1.0-fix_gtkdoc_1.32.patch
Patch3:         libpreludedb-5.1.0-force_preludedb_admin_with_py3.patch
Patch4:         libpreludedb-5.1.0-update_m4_postgresql.patch
Patch5:         libpreludedb-5.1.0-Add-pkg-config-file.patch
Patch6:         libpreludedb-5.1.0-Fix_libdir_definition.patch
Patch7:         libpreludedb-5.1.0-fix-test_rwlock1.patch
Patch8:         libpreludedb-5.1.0-fix_thread_create.patch
BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  bison
BuildRequires:  chrpath
BuildRequires:  flex
BuildRequires:  gtk-doc gtk-doc-mkpdf
BuildRequires:  glib2-devel libgio libgio-devel
BuildRequires:  swig
BuildRequires:  pkgconfig(gnutls)
BuildRequires:  libgpg-error-devel
BuildRequires:  libmariadb-devel
BuildRequires:  postgresql-devel
BuildRequires:  pkgconfig(sqlite3)
BuildRequires:  pkgconfig(libprelude) >= %{version}
BuildRequires:  pkgconfig(openssl)
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  python3-devel
BuildRequires:  pkgconfig(zlib)

%ifnarch s390
BuildRequires:  valgrind
%endif

Requires: preludedb-mysql
Requires: preludedb-pgsql
Requires: preludedb-sqlite3

# Upstream do not use explicit version of gnulib, just checkout
# and update files. In libprelude 5.1.0, the checkout has been done
# on 2018-09-03
Provides:       bundled(gnulib) = 20180903
Source44: import.info

%description
The PreludeDB Library provides an abstraction layer upon the type and the
format of the database used to store IDMEF alerts. It allows developers to use
the Prelude IDMEF database easily and efficiently without worrying about SQL,
and to access the database independently of the type/format of the database.

%description -l ru_RU.UTF-8
PreludeDB библиотека предоставляет несколько уровеней абстракции и форматов
баз данных для хранения IDMEF алертов. Она позволяет разработчикам
использовать базу данных Prelude IDMEF легко и эффективно не беспокоясь
о SQL, и получать доступ к базе данных независимо от ее формата.

%package devel
Group: Development/C
Summary:        Libraries and headers for PreludeDB
Requires:       %{name} = %{version}-%{release}

%description devel
Libraries and headers you can use to access Prelude database using the Prelude
Library. The PreludeDB Library provides an abstraction layer upon the type and
the format of the database used to store IDMEF alerts. It allows developers to
use the Prelude IDMEF database easily and efficiently without worrying about
SQL, and to access the database independently of the type/format of the
database.

%package -n preludedb-tools
Group: System/Libraries
Summary:        Command-line tools for %{name}
Requires:       %{name} = %{version}-%{release}

%description -n preludedb-tools
Provides a convenient interface for accessing Prelude alerts.

%package -n python3-module-preludedb
Group: System/Libraries
Summary:        Python 3 bindings for preludedb
Requires:       %{name} = %{version}-%{release}
%{?python_provide:%python_provide python3-prelude}

%description -n python3-module-preludedb
Provides python 3 bindings for preludedb.

%package -n preludedb-mysql
Group: System/Libraries
Summary:        Plugin to use prelude with a MySQL database
Requires:       %{name} = %{version}-%{release}

%description -n preludedb-mysql
This plugin authorize prelude to store alerts into a MySQL
database.

%package -n preludedb-pgsql
Group: System/Libraries
Summary:        Plugin to use prelude with a PostgreSQL database
Requires:       %{name} = %{version}-%{release}

%description -n preludedb-pgsql
This plugin authorize prelude to store alerts into a PostgreSQL
database.

%package -n preludedb-sqlite3
Group: System/Libraries
Summary:        Plugin to use prelude with a SQLite3 database
Requires:       %{name} = %{version}-%{release}

%description -n preludedb-sqlite3
This plugin authorize prelude to store alerts into a SQLite3
database.

%package doc
Group: System/Libraries
Summary:        Documentation for preludedb
BuildArch:      noarch

%description doc
Provides documentation for preludedb generated by gtk-doc.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1


%build
%configure \
    --disable-rpath \
    --disable-static \
    --enable-shared \
    --includedir=%{_includedir}/%{name} \
    --with-swig \
    --with-perl-installdirs=vendor \
    --without-python2 \
    --with-python3 \
    --enable-gtk-doc \
    --with-html-dir=%{_docdir}/%{name}-devel
sed -i -e 's! -shared ! -Wl,--as-needed\0!g' libtool
%make_build

%install
%makeinstall_std

chrpath -d %{buildroot}%{_libdir}/*.so.*

find %{buildroot} -name '*.la' -delete
find %{buildroot} -name 'perllocal.pod' -delete
find %{buildroot} -name '.packlist' -delete

chmod +x %{buildroot}%{_datadir}/%{name}/classic/mysql2pgsql.sh
chmod +x %{buildroot}%{_datadir}/%{name}/classic/mysql2sqlite.sh

# Enable test again after fixing #1629893
#%check
#%make_build check



%files
%{_libdir}/%{name}.so.%{major}
%{_libdir}/%{name}.so.%{major}.*
%{_libdir}/%{name}cpp.so.%{cppmajor}
%{_libdir}/%{name}cpp.so.%{cppmajor}.*
%dir %{_libdir}/%{name}/
%dir %{_libdir}/%{name}/plugins
%dir %{_libdir}/%{name}/plugins/formats
%dir %{_libdir}/%{name}/plugins/sql
%{_libdir}/%{name}/plugins/formats/classic.so
%doc --no-dereference COPYING LICENSE.README HACKING.README
%doc README NEWS

%files devel
%{_datadir}/%{name}
%{_bindir}/%{name}-config
%{_libdir}/%{name}.so
%{_libdir}/%{name}cpp.so
%{_includedir}/%{name}
%{_datadir}/aclocal/%{name}.m4
%{_mandir}/man1/%{name}-config.1*

%files -n preludedb-tools
%{_bindir}/preludedb-admin
%{_mandir}/man1/preludedb-admin.1*

%files -n python3-module-preludedb
%{python3_sitelibdir}/_preludedb.*so
%{python3_sitelibdir}/__pycache__/preludedb.cpython-??.*pyc
%{python3_sitelibdir}/preludedb-%{version}-py?.?.egg-info
%{python3_sitelibdir}/preludedb.py

%files -n preludedb-mysql
%{_libdir}/%{name}/plugins/sql/mysql.so
%dir %{_datadir}/%{name}/classic
%{_datadir}/%{name}/classic/mysql*.sql

%files -n preludedb-pgsql
%{_libdir}/%{name}/plugins/sql/pgsql.so
%dir %{_datadir}/%{name}/classic
%{_datadir}/%{name}/classic/pgsql*.sql

%files -n preludedb-sqlite3
%{_libdir}/%{name}/plugins/sql/sqlite3.so
%dir %{_datadir}/%{name}/classic
%{_datadir}/%{name}/classic/sqlite*.sql

%files doc
%{_docdir}/%{name}-devel
%doc --no-dereference COPYING LICENSE.README HACKING.README
%doc ChangeLog README NEWS

%changelog
