%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libseccomp
Version: 2.5.6
Release: alt1
Summary: High level interface to the Linux Kernel's seccomp filter
License: LGPLv2.1+
Group: System/Libraries
Url: https://github.com/seccomp/libseccomp

Source: %name-%version.tar

BuildRequires: gperf
%{?!_without_check:%{?!_disable_check:
BuildRequires: /proc
}}

%description
The libseccomp library provides and easy to use, platform independent,
interface to the Linux Kernel's syscall filtering mechanism: seccomp.
The libseccomp API is designed to abstract away the underlying BPF based
syscall filter language and present a more conventional function-call
based filtering interface that should be familiar to, and easily adopted
by application developers.

%package devel
Summary: Development files of %name
Group: Development/C
Requires: %name = %EVR

%description devel
The libseccomp library provides and easy to use, platform independent,
interface to the Linux Kernel's syscall filtering mechanism: seccomp.
The libseccomp API is designed to abstract away the underlying BPF based
syscall filter language and present a more conventional function-call
based filtering interface that should be familiar to, and easily adopted
by application developers.

This package contains development files of %name.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static
%make_build V=1

%install
%makeinstall_std V=1

# Relocate shared library from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
        t=$(readlink -v "$f")
        ln -rsnf %buildroot/%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

install -p tools/scmp_api_level     %buildroot%_bindir
install -p tools/scmp_app_inspector %buildroot%_bindir
install -p tools/scmp_arch_detect   %buildroot%_bindir
install -p tools/scmp_bpf_disasm    %buildroot%_bindir
install -p tools/scmp_bpf_sim       %buildroot%_bindir

%check
unset MAKEFLAGS
export  LIBSECCOMP_TSTCFG_JOBS=0 \
	LIBSECCOMP_TSTCFG_TYPE=live \
	LIBSECCOMP_TSTCFG_MODE_LIST=c
%make_build check V=1

%define _customdocdir %_docdir/%name

%files
/%_lib/lib*.so.*

%files devel
%doc CHANGELOG CREDITS *.md src/syscalls.csv
%_bindir/scmp_*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_man1dir/*
%_man3dir/*

%changelog
