%define _unpackaged_files_terminate_build 1

%define _libexecdir %prefix/libexec

%def_disable check

Name: libsemanage
Epoch: 1
Version: 3.2
Release: alt1
Summary: Library, which provides an interface for SELinux management
Group: System/Libraries
License: LGPLv2.1+
Url: https://github.com/SELinuxProject/selinux

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: bzlib-devel flex libustr-devel libaudit-devel
BuildRequires: libsepol-devel >= %version
BuildRequires: libselinux-devel >= %version
BuildRequires: swig python3-devel
%{!?_disable_check:BuildRequires: CUnit-devel libsepol-devel-static >= %version libselinux-devel-static >= %version }

%description
This package provides the shared libraries for the manipulation of
SELinux binary policies. It is used by checkpolicy (the policy compiler)
and similar tools, as well as by programs like load_policy that need
to perform specific transformations on binary policies such as
customizing policy boolean settings. This contains the run-time
libraries needed by such tools.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
Header files and libraries for SELinux policy manipulation tools
This package provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as
well as by programs like load_policy that need to perform specific
transformations on binary policies such as customizing policy boolean
settings. It contains the static libraries and header files needed
for developing applications that manipulate SELinux binary policies.

%package devel-static
Summary: Development files for %name
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
Static libraries for SELinux policy manipulation tools.

%package utils
Summary: Utils for checking and mainplating policy binaries Security-enhanced Linux
Group: System/Configuration/Other
Provides: semanage_migrate_store = %EVR
Requires: %name = %EVR
Requires: python3-module-selinux python3-module-semanage

%description utils
libsepol provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as well
as by programs like load_policy that need to perform specific transformations
on binary policies such as customizing policy boolean settings.

%package -n python3-module-semanage
Summary: Python module for %name
Group: System/Configuration/Other
Requires: %name = %EVR

%description -n python3-module-semanage
Python bindings  for SELinux policy manipulation tools
This package provides python bindings for the manipulation of SELinux
binary policies.

%prep
%setup
%patch0 -p1

%build
%make_build CFLAGS="%optflags" LIBDIR=%_libdir SHLIBDIR=%_lib LIBEXECDIR=%_libexecdir all
%make_build CFLAGS="%optflags" LIBDIR=%_libdir SHLIBDIR=%_lib LIBEXECDIR=%_libexecdir pywrap PYTHON=python3

%install
%makeinstall_std LIBDIR=%_libdir SHLIBDIR=/%_lib install-pywrap PYTHON=python3

# TODO: currently only man5dir is translated. If other man pages are translated, %%find_lang use should be improved
%find_lang --with-man --all-name %name

%check
%make_build test

%files -f %name.lang
%dir %_sysconfdir/selinux
%config(noreplace) %_sysconfdir/selinux/*
/%_lib/*.so.*
%_man5dir/*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man3dir/*

%files devel-static
%_libdir/*.a

%files utils
%_libexecdir/selinux/*

%files -n python3-module-semanage
%python3_sitelibdir/*

%changelog
