%def_enable snapshot
%define _libexecdir %_prefix/libexec

%define _name tepl
%define ver_major 5.99
%define api_ver 6

%def_enable gtk_doc
%def_enable introspection
# display required
%def_disable check
%def_disable installed_tests

Name: lib%_name
Version: %ver_major.0
Release: alt1

Summary: GTK+ Text Editor Framework
License: LGPL-3.0-or-later
Group: System/Libraries
Url:  https://wiki.gnome.org/Projects/Tepl

%if_disabled snapshot
Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.64
%define gtk_doc_ver 1.0
%define gtk_ver 3.22
%define gtksource_ver 4.0
%define amtk_ver 5.0

BuildRequires(pre): meson rpm-build-gnome rpm-build-gir
BuildRequires: glib2-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libgtksourceview4-devel >= %gtksource_ver
BuildRequires: libxml2-devel libuchardet-devel gtk-doc >= %gtk_doc_ver
BuildRequires: pkgconfig(amtk-5) >= %amtk_ver
BuildRequires: vala-tools
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.6.7 libgtk+3-gir-devel libgtksourceview4-gir-devel libamtk-gir-devel}

%description
Tepl is a library that eases the development of GtkSourceView-based
text editors and IDEs. Tepl is the acronym for "Text editor product
line".

%package devel
Summary: Development environment for Tepl
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains the necessary components to develop for Tepl,
GTK+ Text Editor Framework.

%package devel-doc
Summary: Development documentation for Tepl
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version-%release

%description devel-doc
Tepl is a library that eases the development of GtkSourceView-based
text editors and IDEs. Tepl is the acronym for "TK+ Text Editor
Framework"

This package contains development documentation for Tepl.

%package gir
Summary: GObject introspection data for the Tepl library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Tepl library

%package gir-devel
Summary: GObject introspection devel data for the Tepl library
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Tepl library

%package tests
Summary: Tests for the Tepl library
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Tepl library.

%prep
%setup -n %_name-%version

%build
%meson \
	%{?_enable_gtk_doc:-Dgtk_doc=true} \
	%{?_enable_installed_tests:-Dinstalled_tests=true}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%_name.lang %_name %{_name}-%api_ver

%check
%meson_test

%files -f %_name.lang
%_libdir/%name-%api_ver.so.*
%doc NEWS README*

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
#%_vapidir/*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name-%api_ver/
%endif

%if_enabled introspection
%files gir
%_typelibdir/Tepl-%api_ver.typelib

%files gir-devel
%_girdir/Tepl-%api_ver.gir
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name-%api_ver/
%_datadir/installed-tests/%_name-%api_ver/
%endif


%changelog
