%ifarch %e2k
%def_disable clang
%else
%def_enable clang
%endif

%define upstream_git c60ac40

# check version in include/libyuv/version.h
Name: libyuv
Version: 0.0.1874
Release: alt1

Summary: YUV conversion and scaling functionality library

License: BSD
Group: Development/C
Url: http://code.google.com/p/libyuv/

# Source-url: https://chromium.googlesource.com/libyuv/libyuv/+archive/%upstream_git.tar.gz
Source: %name-%version.tar

Patch0: libyuv-alt-buildfix.patch

%if_enabled clang
BuildRequires: clang
%else
BuildRequires: gcc-c++
%endif

BuildRequires(pre): rpm-macros-cmake

BuildRequires: cmake libstdc++-devel
BuildRequires: libjpeg-devel
BuildRequires: libgtest-devel

%description
This is an open source project that includes YUV conversion and scaling
functionality. Converts all webcam formats to YUV (I420). Convert YUV to
formats for rendering/effects. Rotate by 90 degrees to adjust for mobile
devices in portrait mode. Scale YUV to prepare content for compression,
with point, bilinear or box filter.

%package devel
Summary: The development files for %name
Group: Development/C
Requires: pkgconfig
Requires: %name = %EVR

%description devel
Additional header files for development with %name.

%package tools
Summary: Tools for %name
Group: File tools
Requires: pkgconfig
Requires: %name = %EVR

%description tools
yuvconvert tool.

%prep
%setup
%patch0 -p2

%build
%define optflags_lto %nil
%ifarch %ix86
    %add_optflags -msse2
%endif
%if_enabled clang
export CC=clang
export CXX=clang++
%endif
%cmake \
    -DUNIT_TEST=1 \
    -DCMAKE_SKIP_BUILD_RPATH=1
%cmake_build

%install
%cmake_install
rm -rv %buildroot/usr/lib/libyuv.a

%check
$(echo */libyuv_unittest)

%files
%doc AUTHORS LICENSE PATENTS
%_libdir/%name.so.*

%files tools
%_bindir/yuvconvert
#_bindir/yuvconstants

%files devel
%_includedir/%name/
%_includedir/%name.h
%_libdir/%name.so
%_libdir/pkgconfig/%name.pc

%changelog
