Name: libzio
Version: 1.06
Release: alt1

Summary: A library for accessing compressed text files
License: GPLv2+
Group: System/Libraries
Url: http://libzio.sourceforge.net/

# http://downloads.sourceforge.net/libzio/libzio-%version.tar.bz2
Source: libzio-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: zlib-devel bzlib-devel liblzma-devel xz

%package devel
Summary: Development files for the libzio library
Group: Development/C
Requires: %name = %version-%release

%description
Libzio provides a wrapper function for reading or writing gzip, bzip2
and lzma-compressed files with FILE streams.

%description devel
Libzio provides a wrapper function for reading or writing gzip, bzip2
and lzma-compressed files with FILE streams.

This package contains library and header files needed for
building libzio-aware applications.

%prep
%setup
%patch -p1

%build
%def_enable Werror
%make_build libdir=/%_lib noweak tests testt testx

%install
%make_install install-shared install-data \
	DESTDIR=%buildroot libdir=/%_lib mandir=%_mandir

# Relocate development library from /%_lib/ to %_libdir/.
mkdir -p %buildroot%_libdir
for f in %buildroot/%_lib/*.so; do
	t=$(readlink "$f")
	ln -s ../../%_lib/"$t" "%buildroot%_libdir/${f##*/}"
	rm "$f"
done

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
rm -f sample* out
for s in gz bz2 lzma xz; do
	ln -s sample sample.$s
done
for f in *; do
	[ -f "$f" -a ! -L "$f" ] || continue
	for comp in gzip bzip2 lzma xz; do
		$comp -c < "$f" > sample
		for s in '' .gz .bz2 .lzma .xz; do
			LD_LIBRARY_PATH=%buildroot/%_lib ./testt sample$s > out
				cmp "$f" out
			cat sample$s |
				LD_LIBRARY_PATH=%buildroot/%_lib ./tests ${comp:0:1} > out
				cmp "$f" out
		done
	done
done
rm sample* out
for f in *; do
	[ -f "$f" -a ! -L "$f" ] || continue
	rm -f sample*
	LD_LIBRARY_PATH=%buildroot/%_lib ./testx < "$f" > sample ''
	cmp "$f" sample
	LD_LIBRARY_PATH=%buildroot/%_lib ./testx < "$f" > sample.gz g
	gzip -dc <sample.gz |cmp "$f" -
	LD_LIBRARY_PATH=%buildroot/%_lib ./testx < "$f" > sample.bz2 b
	bzip2 -dc <sample.bz2 |cmp "$f" -
	LD_LIBRARY_PATH=%buildroot/%_lib ./testx < "$f" > sample.xz x
	xz -dc <sample.xz |cmp "$f" -
	LD_LIBRARY_PATH=%buildroot/%_lib ./testx < "$f" > sample.lzma l
	lzma -dc <sample.lzma |cmp "$f" -
done

%files
%doc README
/%_lib/*.so.*

%files devel
%_libdir/*.so
%_includedir/*
%_man3dir/*

%changelog
