%define _unpackaged_files_terminate_build 1

%define ver_major 2.22
%define ver_minor 0
%define _lily_dir %_datadir/%name/%version
%define _texmf %_datadir/texmf

Name: lilypond
Version: %ver_major.%ver_minor
Release: alt1
Group: Publishing
Summary: A program for printing sheet music
License: GPLv3+ with Font-exception-2.0 and GFDL-1.3 and MIT and OFL-1.1
Url: https://lilypond.org

Source: %name-%version.tar
Source1: russian-lirycs-test.ly

BuildRequires(pre): rpm-build-vim
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: gcc-c++ emacs emacs-devel flex fontconfig-devel fontforge guile-devel
BuildRequires: help2man libfreetype-devel libpango-devel makeinfo python-devel texlive
BuildRequires: texlive-collection-basic

Requires: texlive-collection-basic

%add_python3_lib_path %_datadir/%name
%add_python3_req_skip __main__

%package -n emacs-mode-%name
Summary: Major mode for editing GNU LilyPond music scores
Group: Editors
BuildArch: noarch
Requires: %name = %EVR

%package -n emacs-mode-%name-el
Summary: The Emacs Lisp sources for bytecode included in emacs-mode-%name
Group: Development/Other
BuildArch: noarch
Requires: emacs-mode-%name = %EVR

%package -n vim-plugin-%name
Summary: Vim plugin for editing GNU LilyPond music scores
Group: Editors
BuildArch: noarch
Requires: %name = %EVR

%description
LilyPond is a music typesetter. It produces beautiful sheet music using
a high level description file as input. Lilypond is part of the GNU
project. This package contains the utilities for converting the music
source (.ly) files into printable output.

%description -n emacs-mode-%name
emacs-mode-%name provides syntax coloring, inserting tags,
PS-compilation, PS-viewing and MIDI-play.
All Emacs Lisp code is byte-compiled, install emacs-mode-%name-el for sources.

%description -n emacs-mode-%name-el
emacs-mode-%name-el contains the Emacs Lisp sources for the bytecode
included in the emacs-mode-%name package, that extends the Emacs editor.
You need to install emacs-mode-%name-el only if you intend to modify any of the
emacs-mode-%name code or see some Lisp examples.

%description -n vim-plugin-%name
vim-plugin-%name provides syntax coloring, completion and compilation.

%prep
%setup
subst 's|package_infodir = $(infodir)/$(package)|package_infodir = $(infodir)|' config.make.in

%build
%configure \
	--with-texgyre-dir=/usr/share/texmf-dist/fonts/opentype/public/tex-gyre/ \
	--disable-documentation \
	%nil

%make_build

%install
%makeinstall_std \
	vimdir=%vim_runtime_dir
help2man %buildroot%_bindir/lilypond > %buildroot%_man1dir/lilypond.1

# install russian-lirycs-test.ly
install -m644 %SOURCE1 .

# Install Emacs-mode files
mkdir -p %buildroot/%_emacs_sitestart_dir
mv %buildroot%_emacslispdir/%name-init.el %buildroot%_emacs_sitestart_dir/
for i in %buildroot%_emacslispdir/%{name}*.el; do
%byte_compile_file $i
done

# Do not map keys
sed -i '/^".*<\(S-\)\?F[[:digit:]]\+>/,/^"/{/^[^"]/s/^/" /}' %buildroot%vim_runtime_dir/ftplugin/lilypond.vim
# Guard
! grep ^map %buildroot%vim_runtime_dir/ftplugin/lilypond.vim ||exit 1

#FIXME:msp:
# These files cannot pass verify-info check;
rm -f %buildroot%_infodir/lilypond* %buildroot%_infodir/music*

%find_lang %name

%files -f %name.lang
%doc COPYING COPYING.FDL LICENSE LICENSE.DOCUMENTATION LICENSE.OFL
%doc DEDICATION HACKING INSTALL.txt NEWS.txt README.md ROADMAP
%doc russian-lirycs-test.ly
%_bindir/*
%_datadir/%name
#%_infodir/*
%_man1dir/*

%files -n emacs-mode-%name
%config(noreplace) %_emacs_sitestart_dir/%name-init.el
%_emacslispdir/%{name}*.elc

%files -n emacs-mode-%name-el
%_emacslispdir/%{name}*.el

%files -n vim-plugin-%name
%vim_runtime_dir/compiler/*
%vim_runtime_dir/ftdetect/*
%vim_runtime_dir/ftplugin/*
%vim_runtime_dir/indent/*
%vim_runtime_dir/syntax/*

%changelog
