%define module_name lin-tape
# Missing lin_taped.c in sources
%def_without daemon

Name: lin-tape
Version: 3.0.56
Release: alt1

Summary: IBM Tape SCSI Device Driver for Linux
License: GPL-2.0 and LGPL-2.1
Group: Development/Kernel
URL: http://www.ibm.com/support/fixcentral/

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

Source: lin_tape-%version.tgz

BuildArch: noarch

BuildRequires(pre): rpm-build-kernel

%description
The IBM Tape Device Driver, lin_tape, provides attachment and advance
functionality for use with IBM and other vendor tape devices to Linux
compatible platforms.

%package -n kernel-source-%module_name
Summary: The kernel mode drivers for IBM Tape SCSI Device
Group: Development/Kernel

%description -n kernel-source-%module_name
%{summary}.

%prep
%setup -n lin_tape-%version

%build
%if_with daemon
%make_build lin_taped
%endif

%install
%if_with daemon
install -Dpm 755 lin_taped %buildroot%_bindir/lin_taped
install -Dpm 755 lin_tape %buildroot%_sbindir/lin_tape
install -Dpm 666 IBM_tape.h %buildroot%_includedir/sys/IBM_tape.h
install -Dpm 644 lin_tape.service %buildroot%_unitdir/lin_tape.service
%endif

mkdir -p %kernel_srcdir
mkdir ../kernel-source-%module_name-%version
cp -a * ../kernel-source-%module_name-%version
cd ..
tar -cjf %kernel_srcdir/kernel-source-%module_name-%version.tar.bz2 kernel-source-%module_name-%version

%if_with daemon
%post
%post_service lin_tape

%preun
%preun_service lin_tape

%files
%doc lin_tape.ReadMe lin_tape_daemon.ReadMe
%_bindir/lin_taped
%_sbindir/lin_tape
%_includedir/sys/IBM_tape.h
%_unitdir/lin_tape.service
%endif

%files -n kernel-source-%module_name
%attr(0644,root,root) %kernel_src/kernel-source-%module_name-%version.tar.bz2

%changelog
