Name: linux-pam
Version: 1.6.1
Release: alt1

Summary: Pluggable Authentication Modules
# The library is BSD-style *without* advertising clause, with option to relicense as GPLv2+.
License: BSD-3-Clause or GPLv2+
Group: System/Base
Url: https://github.com/linux-pam

%def_disable static
%def_enable nls
%def_enable audit
%def_enable selinux
%def_enable lastlog

# Linux-PAM name suffix
%define _pam_name_suffix	0

# Used for pam module package naming.
%define	make_pam_name()	pam%{_pam_name_suffix}_%{1}
%define	set_pam_name()	%global pam_name %(n='%{1}'; s="${n#pam_}"; [ "$n" = "$s" ] && echo -n "$n" || echo -n "pam%{_pam_name_suffix}_$s")

# Linux-PAM modules directory.
%define	_pam_modules_dir	/%_lib/security

# Linux-PAM library soname suffix.
%define _pam_so_suffix		%{nil}

# Linux-PAM library package name, used for tracking package dependencies.
%define	libpam			libpam%{_pam_name_suffix}

# git://git.altlinux.org/gears/l/linux-pam.git
Source: %name-%version-%release.tar

%define helperdir /sbin
%define _pamdir %_sysconfdir/pam.d
%define _secdir %_sysconfdir/security
%define docdir %_docdir/Linux-PAM-%version

BuildRequires: rpm-build >= 0:4.0.4-alt55

# Required for pam_conv1.
BuildRequires: flex

# Required for pam_userdb.
BuildRequires: libdb4-devel

# Required for docs.
BuildRequires: docbook5-schemas docbook5-style-xsl xsltproc w3m

# Required for audit support.
%{?_enable_audit:BuildRequires: libaudit-devel}

# Required for SELinux support.
%{?_enable_selinux:BuildRequires: libselinux-devel}

%package -n %libpam
Summary: Shared libraries for running PAM-based software
Group: System/Libraries
PreReq: pam-common
Provides: libpam(include), libpam(substack), libpam(optional_module)
Provides: libpam = %version-%release
Obsoletes: libpam

%package -n %libpam-devel
Summary: Libraries and header files for developing PAM-aware software
Group: Development/C
Requires: %libpam = %version-%release
Requires: rpm-macros-pam%{_pam_name_suffix} = %version-%release
Provides: libpam-devel = %version-%release, pam-devel = %version-%release
Obsoletes: libpam-devel, pam-devel
Conflicts: libpam2-devel

%package -n %libpam-devel-static
Summary: Static libraries for developing PAM-aware software
Group: Development/C
Requires: %libpam-devel = %version-%release
Provides: libpam-devel-static = %version-%release
Obsoletes: libpam-devel-static
Conflicts: libpam2-devel-static

%package -n pam
Summary: Pluggable Authentication Modules
Group: System/Base
Provides: %_secdir/limits.d
Requires: %libpam = %version-%release, pam-common >= 1.1
Obsoletes: pamconfig

%package -n pam-doc
Summary: Linux-PAM documentation
Group: Development/C
BuildArch: noarch
Requires: pam = %version-%release

%package -n %{make_pam_name timestamp}
Summary: Authenticate using cached successful authentication attempts
License: GPLv2+
Group: System/Base
Requires: pam = %version-%release
Provides: pam_timestamp = %version-%release

%package -n rpm-macros-pam%{_pam_name_suffix}
Summary: Set of RPM macros for packaging PAM modules
License: GPLv2+
Group: System/Base
BuildArch: noarch
Provides: rpm-macros-pam = %version-%release
Conflicts: rpm-macros-pam2
Obsoletes: pam_timestamp, pam_timestamp0

%description
Linux-PAM (Pluggable Authentication Modules) is a system security tool
that allows system administrators to set authentication policy without
having to recompile programs that handle authentication.

%description -n %libpam
Linux-PAM (Pluggable Authentication Modules) is a system security tool
that allows system administrators to set authentication policy without
having to recompile programs that handle authentication.

This package contains shared libraries required for running both
PAM-aware applications and modules for use with Linux-PAM.

%description -n %libpam-devel
Linux-PAM (Pluggable Authentication Modules) is a system security tool
that allows system administrators to set authentication policy without
having to recompile programs that handle authentication.

This package contains header files and development libraries used for
building both PAM-aware applications and modules for use with Linux-PAM.

%description -n %libpam-devel-static
Linux-PAM (Pluggable Authentication Modules) is a system security tool
that allows system administrators to set authentication policy without
having to recompile programs that handle authentication.

This package contains static libraries used for building statically
linked PAM-aware applications for use with Linux-PAM.

%description -n pam
Linux-PAM (Pluggable Authentication Modules) is a system security tool
that allows system administrators to set authentication policy without
having to recompile programs that handle authentication.

%description -n pam-doc
Linux-PAM (Pluggable Authentication Modules) is a system security tool
that allows system administrators to set authentication policy without
having to recompile programs that handle authentication.

This package contains detailed Linux-PAM documentation.

%description -n %{make_pam_name timestamp}
The pam_timestamp module implements sudo-style authentication
timestamps.

See pam_timestamp(8) for details.

%description -n rpm-macros-pam%{_pam_name_suffix}
This packages contains RPM macros for packaging PAM modules.

%prep
%setup -n %name-%version-%release
cp -p alt/pam_listfile.c modules/pam_listfile/

find -type f \( -name .cvsignore -o -name \*~ -o -name \*.orig \) -delete

%build
./autogen.sh
%configure \
	--libdir=/%_lib \
	--sbindir=/sbin \
	--includedir=%_includedir/security \
	--docdir=%docdir \
	--disable-prelude \
	--disable-unix \
	--enable-Werror \
	%{subst_enable lastlog} \
	%{subst_enable selinux} \
	%{subst_enable audit} \
	%{subst_enable nls} \
	%{subst_enable static} \
	#
%make_build \
	pkgconfigdir=%_pkgconfigdir \
	sepermitlockdir=%_lockdir/sepermit \
	servicedir=%_unitdir \
	#

%install
%makeinstall_std \
	pkgconfigdir=%_pkgconfigdir \
	sepermitlockdir=%_lockdir/sepermit \
	servicedir=%_unitdir \
	#

# Relocate development libraries from /%_lib/ to %_libdir/.
mkdir -p %buildroot%_libdir
mv %buildroot/%_lib/*.*a %buildroot%_libdir/
/sbin/ldconfig -nv %buildroot/%_lib
for f in %buildroot/%_lib/*.so; do
	t=$(readlink -v "$f")
	ln -s ../../%_lib/"$t" "%buildroot%_libdir/${f##*/}"
	rm -f "$f"
done
rm -f %buildroot%_pam_modules_dir/*.la

# Make sure that no module exports symbols beyond standard set.
>check.log
for f in %buildroot%_pam_modules_dir/pam*.so; do
	readelf -Ws "$f" |
		grep -w GLOBAL |
		grep -Ewv 'UND|pam_sm_(acct_mgmt|authenticate|chauthtok|close_session|open_session|setcred)'  ||
			continue
	echo "ERROR: ${f##*/} exports symbol(s) beyond standard set." >&2
	echo "${f##*/}" >>check.log
done
! [ -s check.log ] || exit 1

# Make sure that no shared object has undefined symbols.
>check.log
for f in %buildroot/%_lib/lib*.so.0 %buildroot%_pam_modules_dir/pam*.so; do
	LD_LIBRARY_PATH="%buildroot/%_lib" ldd -r "$f" 2>&1 >/dev/null |
		tee -a check.log
done
! [ -s check.log ] || exit 1

# Make sure that none of the modules pull in threading libraries.
>check.log
for f in %buildroot%_pam_modules_dir/pam*.so; do
	# except pam_userdb
	[ "${f##*/}" != pam_userdb.so ] ||
		continue
	LD_LIBRARY_PATH="%buildroot/%_lib" ldd -r "$f" 2>&1 |
		fgrep -q libpthread ||
			continue
	echo "ERROR: ${f##*/} pulls in libpthread." >&2
	echo "${f##*/}" >>check.log
done
! [ -s check.log ] || exit 1

# pam_limits configuration
install -pm644 alt/50-defaults.conf \
	%buildroot%_secdir/limits.d/

# Linux-PAM-specific rpm macros.
install -pDm644 alt/linux-pam.macros \
	%buildroot%_rpmmacrosdir/pam

mkdir -p %buildroot%_tmpfilesdir
install -pm644 alt/faillock.conf %buildroot%_tmpfilesdir/
mkdir -p %buildroot/var/run/faillock

%if_enabled selinux
mkdir -p %buildroot%_lockdir/sepermit
install -pm644 alt/sepermit.conf %buildroot%_tmpfilesdir/
%endif # enabled selinux

# Documentation
mkdir -p %buildroot%docdir/modules
for f in modules/pam_*/README; do
	d="${f%%/*}"
	[ -s "$d/Makefile" ] || continue
	install -pm644 "$f" "%buildroot%docdir/modules/${d##*/}"
done
mkdir -p %buildroot%docdir/html
mv %buildroot%docdir/*.html %buildroot%docdir/html/
install -pm644 alt/PAM-Policy.ALT AUTHORS NEWS Copyright %buildroot%docdir/
find %buildroot%docdir/ -type f -size +4k \( -iname changelog -or -name \*.txt -or -name \*.ps \) -print0 |
	xargs -r0 xz -9f --

# buildreq substitution rules
mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
for n in libpam{,-devel%{?_enable_static:{,-static}}}; do
	echo $n >"%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%libpam${n#libpam}"
done

%find_lang Linux-PAM

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
%make_build -k check VERBOSE=1

%files -n %libpam
%config %_sysconfdir/buildreqs/packages/substitute.d/%libpam
/%_lib/*.so.*
%_pam_modules_dir/pam_deny.so
%_pam_modules_dir/pam_permit.so
%dir %docdir
%docdir/AUTHORS*
%docdir/Copyright*
%docdir/NEWS*

%files -n %libpam-devel
%config %_sysconfdir/buildreqs/packages/substitute.d/%libpam-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*
%dir %docdir
%docdir/PAM*

%if_enabled static
%files -n %libpam-devel-static
%config %_sysconfdir/buildreqs/packages/substitute.d/%libpam-devel-static
%_libdir/*.a
%endif # enabled static

%files -n rpm-macros-pam%{_pam_name_suffix}
%_rpmmacrosdir/pam

%files -n pam -f Linux-PAM.lang
%helperdir/faillock
%helperdir/mkhomedir_helper
%helperdir/pam_namespace_helper
%attr(700,root,root) %helperdir/pwhistory_helper
%_unitdir/pam_namespace.service
%config(noreplace) %_secdir/access.conf
%config(noreplace) %_secdir/faillock.conf
%config(noreplace) %_secdir/time.conf
%config(noreplace) %attr(640,root,wheel) %_secdir/group.conf
%config(noreplace) %_secdir/limits.conf
%config(noreplace) %_secdir/limits.d
%config(noreplace) %_secdir/namespace.*
%config(noreplace) %_secdir/pam_env.conf
%config(noreplace) %_secdir/pwhistory.conf
%config(noreplace) %_sysconfdir/environment
%_tmpfilesdir/faillock.conf
%dir /var/run/faillock/
%if_enabled selinux
%config(noreplace) %_secdir/sepermit.conf
%dir %_lockdir/sepermit/
%_tmpfilesdir/sepermit.conf
%endif # enabled selinux
%_pam_modules_dir/*
%exclude %_pam_modules_dir/pam_deny.so
%exclude %_pam_modules_dir/pam_permit.so
%exclude %_pam_modules_dir/pam_timestamp.so
%_mandir/man[58]/*.*
%exclude %_mandir/man[58]/pam_timestamp*

%files -n %{make_pam_name timestamp}
%attr(700,root,root) %helperdir/pam_timestamp_check
%_pam_modules_dir/pam_timestamp.so
%_mandir/man[58]/pam_timestamp*

%files -n pam-doc
%dir %docdir
%docdir/[a-z]*
%docdir/Linux-PAM*

%changelog
