%define _unpackaged_files_terminate_build 1

Name: local-policy
Version: 0.6.0
Release: alt1.1

Summary: ALT Local Policies Default templates
License: GPLv2+
Group: Other
Url: http://git.altlinux.org/gears/l/local-policy.git

BuildArch: noarch

Requires: control
Requires: control-sshd-permit-root-login

Source0: %name-%version.tar

# https://bugzilla.altlinux.org/45002 :
%filter_from_requires /xmlbeans-scripts/d

%description
Local policies for ALT solutions based on Sisyphus
includes additional control facilities and default policies
templates in PReg format converted to XML.

%prep
%setup -q

%install
for i in sshd-gssapi-auth \
         sshd-allow-groups-list \
         ssh-gssapi-auth \
         krb5-conf-ccache \
         ldap-reverse-dns-lookup \
         ldap-tls-cert-check \
         local-policy-system-access \
         sssd-ad-gpo-access-control \
         sssd-ad-gpo-ignore-unreadable \
         sssd-ad-update-machine-password \
         sssd-cache-credentials \
         sssd-drop-privileges \
         sssd-dyndns-update \
         sssd-dyndns-update-ptr \
         sssd-dyndns-refresh-interval \
         sssd-dyndns-ttl \
         autofs-browse-mode \
         smb-conf-idmap-backend \
         smb-conf-idmap-range \
         smb-conf-machine-password-timeout
do
        install -pD -m755 "controls/$i" \
                "%buildroot%_sysconfdir/control.d/facilities/$i"
done

install -pD -m755 "controls/functions-local-policy" \
        "%buildroot%_sysconfdir/control.d/"

mkdir -p "%buildroot%_datadir/%name"
cp -r policies/* "%buildroot%_datadir/%name"
mkdir -p "%buildroot%_sysconfdir/%name"
mkdir -p "%buildroot%_sysconfdir/%name-system"

%pre
%_sbindir/groupadd -r -f remote 2> /dev/null ||:
%pre_control local-policy-system-access
if [ ! -f "/var/run/control/local-policy-system-access" ]; then
    [ ! -d "/var/run/control" ] ||
        echo restricted > "/var/run/control/local-policy-system-access"
fi

%post
%post_control -s restricted local-policy-system-access

%files
%dir %attr(0700, root, root) %_sysconfdir/%name-system
%dir %_sysconfdir/%name
%_sysconfdir/control.d/facilities/*
%_sysconfdir/control.d/functions-local-policy
%dir %_datadir/%name
%_datadir/%name/*

%changelog
