%def_with emacs

Name: lout
Version: 3.40
Release: alt4

Summary: The Lout document formatting language
License: GPL
Group: Text tools
Url: http://sourceforge.net/projects/lout/

Source: %name-%version.tar.gz
Source1: %name-mode.el
Source2: fontdefs.ld
Source3: %name-3.40-user.ps.bz2
Patch1: lout-3.40-fedora-cve.patch
Requires: urw-fonts >= 1:2.0-alt9
BuildRequires(pre): rpm-build-fonts
%{?_with_emacs:BuildPreReq: emacs}

%description
Lout is a high-level language for document formatting.  Lout reads a
high-level description of a document (similar in style to LaTeX) and can
produce a PostScript(TM) file for printing or produce plain text.
Lout supports the typesetting of documents which contain floating
figures, table, diagrams, rotated and scaled text or graphics, footnotes,
running headers, footers, an index, a table of contents and bibliography,
cross-references, mathematical equations and statistical graphs.  Lout can
be extended with definitions that should be easier to write than other
languages, since Lout is a high-level language.  Lout supports (with
hyphenation) a variety of languages:  Czech, Danish, Dutch, English,
Finnish, French, German, Norwegian, Russian, Slovenian, Spanish and
Swedish.

Install the lout package if you'd like to try the Lout document formatting
system.  Unless you're already a Lout expert, you'll probably want to also
install the lout-doc package, which contains the documentation for Lout.

%package doc
Summary: The documentation for the Lout document formatting language
Group: Text tools
BuildArch: noarch

%description doc
The lout-doc package includes all of the documentation for the Lout
document formatting language.  The documentation includes manuals for
regular users and for experts, written in Lout and available as
PostScript(TM) files.  The documentation provides good examples for how to
write large documents with Lout.

If you're installing the lout package, you should install the lout-doc
package.

%prep
%setup
%patch1 -p1
rm -f doc/user/.pie_intr.swp

cp -a %SOURCE2 data
cp -a %SOURCE3 .

%build
sed -i 's|@SUFF64@|%_libsuff|' makefile
%make_build RPM_OPT_FLAGS="%optflags -U_FORTIFY_SOURCE" \
	FONT_DIR="%_fontpathdir/type1" lout prg2lout

%install
install -d %buildroot{%_bindir,%_libdir,%_datadir/locale}
install -d %buildroot{%_man1dir,%_docdir/%name}

%makeinstall_std DATADIR=%_datadir installman installdoc


%if_with emacs
mkdir -p %buildroot%_emacslispdir
install -m 644 %SOURCE1 %buildroot%_emacslispdir
emacs -batch -f batch-byte-compile %buildroot%_emacslispdir/%name-mode.el

install -d %buildroot%_sysconfdir/emacs/site-start.d
cat <<EOF >%buildroot%_sysconfdir/emacs/site-start.d/%name.el
(autoload 'lout-mode "lout-mode" "Major mode for editing Lout text" t)
   (setq auto-mode-alist
      (append '(("\\.lout\\'" . lout-mode)) auto-mode-alist))
EOF
%endif

install -m644 *.ps.bz2 %buildroot%_docdir/%name

# It is the file in the package whose name matches the format emacs or vim uses 
# for backup and autosave files. It may have been installed by  accident.
find %buildroot \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete
# failsafe cleanup if the file is declared as %%doc
find . \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete

%files
%doc blurb README maillist whatsnew
%_bindir/*
%_mandir/man?/*
%_libdir/%name
%exclude %_libdir/%name/font
%if_with emacs
%_emacslispdir/*
%_sysconfdir/emacs/site-start.d/*
%endif

%files doc
%doc %_docdir/%name

%changelog
