%define target_lua_version 5.3

# Original package name LuaExpat
%define oname luaexpat

Name: lua%target_lua_version-module-%oname
Version: 1.3.0
Release: alt1
Epoch: 1

Summary: XML Expat parsing
License: MIT
Group: Development/Other
Url: https://matthewwild.co.uk/projects/luaexpat/

%if "%target_lua_version" == "5.3"
Obsoletes: lua-module-%oname < %EVR
Provides: lua-module-%oname = %version
%else
Obsoletes: lua5-%oname < %EVR
Provides: lua5-%oname = %version
Obsoletes: lua-expat < %EVR
Provides: lua-expat = %version
%endif

# repacked https://matthewwild.co.uk/projects/luaexpat/luaexpat-%version.tar.gz
Source: luaexpat-%version.tar

BuildRequires(pre): rpm-macros-lua >= 1.4
# Automatically added by buildreq on ...
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks
BuildRequires: libexpat-devel

%description
      LuaExpat is a SAX (Simple API for XML) XML parser based on the
      Expat library.

%prep
%setup -n %oname-%version

%build
%make_build \
	CFLAGS="%optflags -std=c99" \
	LUA_V=%target_lua_version \
	LUA_CDIR=%lua53_modulesdir \
	#

%install
%makeinstall_std \
	LUA_V=%target_lua_version \
	LUA_CDIR=%lua53_modulesdir \
	#

%files
%lua_modulesdir/lxp.so
%lua_modulesdir_noarch/lxp/lom.lua
%doc README

%changelog
