%global import_path github.com/lxc/lxd
%global _unpackaged_files_terminate_build 1

%define lxdgroup lxd
%define lxduser lxd

Name:		lxd
Version:	5.0.2
Release:	alt1.git1f388d55
Summary:	LXD -- REST API, command line tool and OpenStack integration plugin for LXC.

Group:		Development/Other
License:	Apache-2.0
URL:		https://%import_path

Source0:	%name-%version.tar
Patch:		%name-%version-%release.patch
Source3:	lxd.default
Source4:	lxd.dnsmasq

# services
Source11:	lxd.service
Source12:	lxd.socket
Source13:	lxd-startup.service


ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-build-golang
# For test/deps/import-busybox
BuildRequires(pre): rpm-build-python3

Requires:	shadow-submap
Requires:	lxc-runtime >= 4.0.0
Requires:	lxcfs
Requires:	btrfs-progs
Requires:	lvm2
Requires:	squashfs-tools
Requires:	rsync
Requires:	iptables
Requires:	ebtables
Requires:	dnsmasq
Requires:	attr

BuildRequires: golang >= 1.18
BuildRequires: libcap-devel
BuildRequires: libuv-devel

BuildRequires: libsqlite3-devel
BuildRequires: libdqlite-devel
BuildRequires: libraft-devel
BuildRequires: libudev-devel
BuildRequires: help2man
# Needed for manpages generation. Accessing to '/proc/self/...'
BuildRequires: /proc

BuildRequires:	liblxc-devel >= 4.0.0
BuildRequires:	libacl-devel

%description
REST API, command line tool and OpenStack integration plugin for LXC.

%prep
%setup -q
%patch -p1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"

%golang_prepare

pushd .build/src/%import_path

#export TAGS="libsqlite3"
#go install -v -tags "libsqlite3" ./...
export CGO_LDFLAGS_ALLOW="(-Wl,-wrap,pthread_create)|(-Wl,-z,now)"
TAGS="libsqlite3" %golang_build lxc fuidshift lxd-benchmark lxc-to-lxd lxd/db lxd
CGO_ENABLED=0 TAGS="netgo" %golang_build lxd-migrate
CGO_ENABLED=0 TAGS="agent,netgo" %golang_build lxd-agent

#%golang_build lxd lxc fuidshift lxd-benchmark lxd-p2c lxc-to-lxd lxd/db
popd

%install
export BUILDDIR="$PWD/.build"
export GOPATH="%go_path"

%golang_install

mkdir -p -- %buildroot/%go_root/bin
for f in %buildroot/%_bindir/*; do
	[ -x "$f" ] || continue
	f="${f##*/}"
	what="$(relative %_bindir/$f %go_root/bin/$f)"
	ln -s -- "$what" %buildroot/%go_root/bin/$f
done

# lxc-bridge
mkdir -p -- %buildroot%_libexecdir/lxd

# configuration
install -D %SOURCE3 %buildroot%_sysconfdir/sysconfig/lxd
# configuration for dnsmasq called in lxd-bridge
install -D %SOURCE4 %buildroot%_sysconfdir/lxd/dnsmasq.conf

#services
# systemd
mkdir -p %buildroot%_unitdir
cp -av %SOURCE11 %buildroot%_unitdir/
cp -av %SOURCE12 %buildroot%_unitdir/
cp -av %SOURCE13 %buildroot%_unitdir/

# install bash completion
mkdir -p %buildroot%_datadir/bash-completion/completions/
cp -av scripts/bash/lxd-client %buildroot%_datadir/bash-completion/completions/

# /var/{lib,log}/lxd
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_logdir/%name

# Install the manpages
mkdir -p %buildroot%_man1dir
help2man %buildroot%_bindir/fuidshift -n "uid/gid shifter" --no-info --no-discard-stderr > %buildroot%_man1dir/fuidshift.1
help2man %buildroot%_bindir/lxc-to-lxd -n "Convert LXC containers to LXD" --no-info --version-string=%version --no-discard-stderr > %buildroot%_man1dir/lxc-to-lxd.1
help2man %buildroot%_bindir/lxd-benchmark -n "The container lightervisor - benchmark" --no-info --no-discard-stderr > %buildroot%_man1dir/lxd-benchmark.1
%buildroot%_bindir/lxd manpage %buildroot%_man1dir/
%buildroot%_bindir/lxc manpage %buildroot%_man1dir/

# cleanup
rm -rf -- %buildroot%go_path

%pre
%_sbindir/groupadd -r -f %lxdgroup 2>/dev/null || :
%_sbindir/useradd  -r -g %lxdgroup -c "LXD daemon" \
   -s /dev/null -d /dev/null %lxduser 2>/dev/null || :

%post
if [ $1 = 1 ]; then
    if ! grep -qs '^root:' /etc/subuid \
       && ! grep -qs '^root:' /etc/subgid \
       && ! grep -qs '^lxd:' /etc/subuid \
       && ! grep -qs '^lxd:' /etc/subuid
    then
        %_sbindir/usermod --add-subgids 100000-165535 root ||:
        %_sbindir/usermod --add-subgids 100000-165535 lxd ||:
        %_sbindir/usermod --add-subuids 100000-165535 root ||:
        %_sbindir/usermod --add-subuids 100000-165535 lxd ||:
   fi
fi

%post_service %name

%preun
%preun_service %name

%files
%doc AUTHORS COPYING
%_bindir/*
%go_root/bin/*
%attr(0751,%lxduser,%lxdgroup) %dir %_localstatedir/%name
%attr(0751,%lxduser,%lxdgroup) %dir %_logdir/%name
#dir %_libexecdir/lxd
#_libexecdir/lxd/*

%_unitdir/*

%_datadir/bash-completion/completions/*

%config(noreplace) %_sysconfdir/sysconfig/*
%dir %_sysconfdir/lxd
%config(noreplace) %_sysconfdir/lxd/dnsmasq.conf

%_man1dir/*

%changelog
