# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: lxqt-session
Version: 1.4.0
Release: alt1.p10

Summary: Session manager
License: LGPL-2.1
Group: Graphical desktop/Other

Url: https://github.com/lxqt/lxqt-session
Source0: %name-%version.tar
Source1: 08lxqt
Patch: fix_XDG_CONFIG_DIRS.patch
Patch1: alt-settings.patch

BuildRequires: gcc-c++ cmake rpm-macros-cmake git-core
BuildRequires: liblxqt-devel qt5-base-devel qt5-tools-devel
BuildRequires: qtxdg-tools-devel
BuildRequires: kf5-kwindowsystem-devel
BuildRequires: rpm-build-xdg libqtxdg-devel xdg-utils xdg-user-dirs
BuildRequires: libudev-devel
BuildRequires: libprocps-devel

Requires: lxqt-themes
Requires: xdg-utils
# separate devel package from qtxdg-tools 3.12.0-alt2
Requires: qtxdg-tools >= 3.12.0-alt2

Provides: razorqt-session = %version
Obsoletes: razorqt-session < 0.7.0

Conflicts: lxqt-common <= 0.11.0

%description
%summary.

%prep
%setup
%autopatch -p1

# https://bugzilla.altlinux.org/32657
sed -i 's,Exec=,Exec=%_bindir/,' xsession/lxqt.desktop.in

%build
%cmake -DPULL_TRANSLATIONS=OFF \
       -DUPDATE_TRANSLATIONS=OFF \
       -DBUNDLE_XDG_UTILS=No
%cmake_build

%install
%cmake_install
install -pDm644 %SOURCE1 %buildroot%_sysconfdir/X11/wmsession.d/08lxqt

%files
%_man1dir/*
%_bindir/*
%_xdgconfigdir/autostart/lxqt-xscreensaver-autostart.desktop
%_desktopdir/*.desktop
%_datadir/xsessions/*.desktop
%_datadir/lxqt/*
%_sysconfdir/X11/wmsession.d/08lxqt
%doc AUTHORS CHANGELOG LICENSE README.md

%changelog
