Group: File tools
%filter_from_requires /.usr.xpg4.bin.sh/d
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %_var
%global bashcompdir %(pkg-config --variable=completionsdir bash-completion)

Name:           lynis
Version:        3.0.9
Release:        alt1
Summary:        Security and system auditing tool
License:        GPLv3
URL:            https://cisofy.com/lynis/
Source0:        https://cisofy.com/files/%name-%version.tar.gz
BuildArch:      noarch
BuildRequires:  bash-completion-util-linux
BuildRequires:  git-core
BuildRequires:  procps
Requires:       audit
Requires:       e2fsprogs
Requires:       module-init-tools

# these dependencies are optional
%filter_from_requires /sbin.kldstat/d
%filter_from_requires /usr.bin.isainfo/d
%filter_from_requires /usr.bin.sw_vers/d
%filter_from_requires /usr.libexec.ApplicationFirewall.socketfilterfw/d
%filter_from_requires /usr.sbin.bootinfo/d
%filter_from_requires /usr.sbin.modinfo/d
%filter_from_requires /usr.sbin.prtconf/d
%filter_from_requires /usr.xpg4.bin.id/d

%description
Lynis is an auditing and hardening tool for Unix/Linux and you might even call
it a compliance tool. It scans the system and installed software. Then it 
performs many individual security control checks. It determines the hardening 
state of the machine, detects security issues and provides suggestions to 
improve the security defense of the system.

%prep
%setup -q -n %name

# make sisyphus_check happy
sed -i -E 's/(\(python)/\13/' include/functions

%build
# Empty build.

%install
mkdir -p %buildroot%_sysconfdir/%name
install -p default.prf %buildroot%_sysconfdir/%name

mkdir -p %buildroot%_bindir
install -p lynis %buildroot%_bindir

mkdir -p %buildroot%_mandir/man8
install -p lynis.8 %buildroot%_mandir/man8

mkdir -p  %buildroot%_datadir/%name/include/
# Forced by upstream. Otherwise these scripts can't be executed.
install -p include/* %buildroot%_datadir/%name/include/
chmod 644 %buildroot%_datadir/%name/include/*

mkdir -p  %buildroot%_datadir/%name/plugins/
install -p plugins/* %buildroot%_datadir/%name/plugins/

cp -pR db/ %buildroot%_datadir/%name/

mkdir -p %buildroot%bashcompdir
install -p extras/bash_completion.d/lynis %buildroot%bashcompdir/

mkdir -p %buildroot%_localstatedir/log/
touch %buildroot%_localstatedir/log/lynis.log
touch %buildroot%_localstatedir/log/lynis-report.dat
for rpm404_ghost in %_localstatedir/log/lynis.log %_localstatedir/log/lynis-report.dat
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%check
# Sanity check
./lynis audit system --quick 

%files
%doc CHANGELOG* CONTRIBUTORS* FAQ* README*
%doc extras/systemd/
%doc --no-dereference LICENSE
%_bindir/lynis
%bashcompdir/*
%_datadir/lynis/
%_mandir/man8/lynis.8*
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/default.prf
%ghost %_localstatedir/log/lynis.log
%ghost %_localstatedir/log/lynis-report.dat

%changelog
