%ifarch %luajit_arches
%def_enable lua
%endif

Name: mpv
Version: 0.36.0
Release: alt1.2

Summary: mpv is a free and open-source general-purpose video player based on MPlayer and mplayer2.
License: GPLv2+
Group: Video

Url: http://mpv.io/
Source: %name-%version.tar
Patch: %name-%version-alt.patch

Packager: %packager

# for %%luajit_arches macro
BuildRequires(pre): rpm-macros-luajit
BuildRequires(pre): meson ninja-build

# Automatically added by buildreq on Fri Feb 14 2014
BuildRequires: libGL-devel libXext-devel libalsa-devel libass-devel libavformat-devel libjpeg-devel libswscale-devel zlib-devel libva-devel

BuildRequires: libpulseaudio-devel libXScrnSaver-devel libXv-devel libXinerama-devel libXrandr-devel libdvdnav-devel libbluray-devel libavfilter-devel

BuildRequires: libswresample-devel libxkbcommon-devel libdrm-devel libv4l-devel libarchive-devel liblcms2-devel libjack-devel

BuildRequires: libenca-devel libuchardet-devel libvulkan-devel libwayland-egl-devel libwayland-cursor-devel libwayland-client-devel wayland-protocols python3-base

BuildRequires: libgbm-devel libplacebo-devel libSDL2-devel libavdevice-devel libXpresent-devel

BuildRequires: libzimg-devel vapoursynth-devel libshaderc-devel nv-codec-headers pipewire-libs-devel libsixel-devel

BuildRequires: /usr/bin/rst2man

%if_enabled lua
BuildRequires: liblua5.1-devel libluajit-devel
%endif

Summary(ru_RU.UTF-8): MPV - это медиапроигрыватель с открытыми исходниками, основанный на проектах MPlayer и mplayer2.

%description
mpv is a movie player based on MPlayer and mplayer2.
It supports a wide variety of video file formats,
audio and video codecs, and subtitle types.

%description -l ru_RU.UTF-8
mpv - это медиапроигрыватель, основанный на проектах
MPlayer и mplayer2. Он поддерживает большое количество
видеоформатов, аудио и видео кодеков и форматов субтитров.

%package -n zsh-completion-%name
Summary: Zsh completion for %name
Group: Shells
BuildArch: noarch
Requires: %name = %version-%release

%description -n zsh-completion-%name
Zsh completion for %name.

%package -n bash-completion-%name
Summary: Bash completion for %name
Group: Shells
BuildArch: noarch
Requires: bash-completion
Requires: %name = %version-%release

%description -n bash-completion-%name
Bash completion for %name.

%package -n libmpv-devel
Summary: Header files for %name
Group: Development/C
Requires: %name = %version-%release

%description -n libmpv-devel
Header files for %name

%package -n libmpv2
Summary: %name shared library
Group: System/Libraries

%description -n libmpv2
This package contains %name shared library

%prep
%setup -n %name-%version
%patch -p1

%build
%meson \
	-D pulse=enabled \
	-D xv=enabled \
	-D vaapi=enabled \
	-D alsa=enabled \
	-D gl-x11=enabled \
%if_enabled lua
	-D lua=enabled \
%endif
	-D libbluray=enabled \
	-D dvdnav=enabled \
	-D libmpv=true \
	-D jack=enabled \
	-D vulkan=enabled \
	-D sdl2=enabled \
	-D vapoursynth=enabled \
	-D pipewire=enabled

%meson_build -v

%install
%meson_install

rm -rfv %buildroot/share/
rm -rfv %buildroot%_iconsdir/hicolor/symbolic/

%files
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/encoding-profiles.conf
%_bindir/%name
%_man1dir/%name.1.*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_iconsdir/hicolor/64x64/apps/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_desktopdir/%name.desktop
%doc Copyright README.md RELEASE_NOTES etc/input.conf etc/mplayer-input.conf etc/mpv.conf etc/restore-old-bindings.conf

%files -n zsh-completion-%name
%_datadir/zsh/site-functions/_mpv

%files -n bash-completion-%name
%_datadir/bash-completion/completions/*

%files -n libmpv-devel
%_libdir/libmpv.so
%_includedir/%name
%_pkgconfigdir/*.pc

%files -n libmpv2
%_libdir/libmpv.so.*

%changelog
