# since 3.21.90 (libmutter-clutter-1.0.so private library)
%set_verify_elf_method unresolved=relaxed

%def_disable snapshot

%define ver_major 40
%define beta %nil
%define api_ver 8
%define xdg_name org.gnome.mutter
%define _libexecdir %_prefix/libexec
%def_enable privatelib
%def_enable remote_desktop
%def_enable installed_tests
# https://github.com/NVIDIA/egl-wayland required
%def_enable egl_device
%def_enable wayland_eglstream

Name: mutter
Version: %ver_major.10
Release: alt1%beta
Epoch: 1

Summary: Clutter based compositing GTK3 Window Manager
Group: Graphical desktop/GNOME
License: GPL-2.0
Url: http://ftp.gnome.org/pub/gnome/sources/%name

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
Patch: mutter-40.0-alt-gsettings_desktop_schemas_dep.patch


%define pkglibdir %_libdir/%name-%api_ver
%define pkgdatadir %_datadir/%name-%api_ver

%add_findprov_lib_path %pkglibdir
%set_typelibdir %pkglibdir
%set_girdir %pkglibdir

# since 3.22 mutter forks Cogl and Clutter libraries into own private libraries
#%%filter_from_provides /[typelib\|gir]([Cally\|Clutter\|Cogl].*/d
#%%filter_from_requires /[typelib\|gir]([Cally\|Clutter\|Cogl].*/d

#https://lists.altlinux.org/pipermail/sisyphus-incominger/2016-October/444041.html

%define gtk_ver 3.20.0
%define gi_ver 0.9.5
%define glib_ver 2.67.3
%define pango_ver 1.46.0
%define cairo_ver 1.10.0
%define Xi_ver 1.7.4
%define wayland_ver 1.18
%define wayland_protocols_ver 1.19
%define upower_ver 0.99.0
%define libinput_ver 0.99.0
%define gsds_ver 40
%define gudev_ver 232
%define pipewire_ver 0.3.21
%define sysprof_ver 3.37
%define json_glib_ver 0.12.0
%define graphene_ver 1.10.2
%define wacom_ver 0.13

Requires: lib%name = %EVR
Requires: zenity
%{?_enable_remote_desktop:Requires: pipewire >= %pipewire_ver}

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson /proc
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libXcomposite-devel libXfixes-devel libXrender-devel
BuildRequires: libXdamage-devel libXtst-devel libXi-devel >= %Xi_ver
BuildRequires: libXcursor-devel libX11-devel libXinerama-devel libXext-devel libXrandr-devel libSM-devel libICE-devel
BuildRequires: libxcb-devel
BuildRequires: libwayland-server-devel >= %wayland_ver wayland-protocols >= %wayland_protocols_ver
BuildRequires: libgdk-pixbuf-devel libgbm-devel
BuildRequires: libstartup-notification-devel zenity libcanberra-gtk3-devel
BuildRequires: libclutter-gir-devel libpango-gir-devel libgtk+3-gir-devel gsettings-desktop-schemas-gir-devel
BuildRequires: libgnome-desktop3-devel libupower-devel >= %upower_ver
BuildRequires: libxkbcommon-x11-devel libinput-devel >= %libinput_ver
BuildRequires: libxkbfile-devel xkeyboard-config-devel libfribidi-devel
BuildRequires: libwacom-devel >= %wacom_ver
BuildRequires: gnome-settings-daemon-devel
BuildRequires: pkgconfig(sysprof-capture-4)
BuildRequires: libgraphene-gir-devel >= %graphene_ver
%{?_enable_remote_desktop:BuildRequires: pipewire-libs-devel >= %pipewire_ver}
# for mutter native backend
BuildRequires: libdrm-devel libsystemd-devel libgudev-devel >= %gudev_ver
BuildRequires: libGL-devel libGLES-devel xorg-xwayland-devel %_bindir/cvt
BuildRequires: libdbus-devel
%{?_enable_egl_device:BuildRequires: libEGL-devel}
%{?_enable_wayland_eglstream:BuildRequires: egl-wayland-devel}

%description
mutter is a minimal X window manager aimed at nontechnical users and is
designed  to  integrate well with the GNOME desktop.  mutter lacks some
features that may be expected by traditional UNIX  or  other  technical
users;  these users may want to investigate other available window man-
agers for use with GNOME or standalone.

%package -n lib%name
Summary: Shared library for Mutter
Group: System/Libraries

%description -n lib%name
This package contains shared library needed to run Mutter.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains headers and development libraries for lib%name

%package -n lib%name-gir
Summary: GObject introspection data for the Mutter library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Mutter library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Mutter library
Group: System/Libraries
Requires: lib%name-devel = %EVR
Requires: lib%name-gir = %EVR
#BuildArch: noarch

%description -n lib%name-gir-devel
GObject introspection devel data for the Mutter library.

%package gnome
Summary: GNOME-specific parts of Mutter
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: gnome-wm
Requires: %name = %EVR

%description gnome
This package contains everything necessary to use Mutter in GNOME desktop
environment.

%package tests
Summary: Tests for the Mutter WM
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Mutter.


%prep
%setup -n %name-%version%beta
%patch
# Also disable KMS modifiers for baikal-vdu
echo 'DRIVERS=="baikal-vdu", SUBSYSTEM=="drm", TAG+="mutter-device-disable-kms-modifiers"' \
>> data/61-%name.rules

%build
%meson \
	-Dintrospection=true \
	%{?_enable_remote_desktop:-Dremote_desktop=true} \
	%{?_enable_egl_device:-Degl_device=true} \
	%{?_enable_wayland_eglstream:-Dwayland_eglstream=true} \
	%{?_disable_sysprof:-Dsysprof=false} \
	%{?_disable_installed_tests:-Dinstalled_tests=false} \
%ifarch %e2k
	-Dclutter_tests=false
%endif
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name creating-%name-themes

%files -f %name.lang
%_bindir/*
%_udevrulesdir/61-%name.rules
%_libexecdir/%name-restart-helper
%dir %pkglibdir/plugins
%pkglibdir/plugins/*.so
%{?_enable_installed_tests:%dir %pkgdatadir}
%_desktopdir/%name.desktop
%_man1dir/*
%doc NEWS README.md

%if_enabled privatelib
%files -n lib%name
%_libdir/lib%name-%api_ver.so.*
%dir %pkglibdir
%pkglibdir/lib%name-clutter-%api_ver.so.*
%pkglibdir/lib%name-cogl-pango-%api_ver.so.*
%pkglibdir/lib%name-cogl-%api_ver.so.*

%files -n lib%name-devel
%_includedir/%name-%api_ver/
%_libdir/lib%name-%api_ver.so
%pkglibdir/*.so
%_pkgconfigdir/*.pc
%endif

%files -n lib%name-gir
%pkglibdir/*.typelib

%files -n lib%name-gir-devel
%pkglibdir/*.gir

%files gnome
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.wayland.gschema.xml
%_datadir/GConf/gsettings/%name-schemas.convert
%_datadir/gnome-control-center/keybindings/*.xml

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name-%api_ver/
%_datadir/installed-tests/%name-%api_ver/
%pkgdatadir/tests/
%endif


%changelog
