Name: netcat
%define datestamp 20100725
Version: 4.0.%datestamp
Release: alt2

Summary: Reads and writes data across network connections using TCP or UDP
License: BSD
Group: Networking/Other
Url: http://www.openbsd.org/cgi-bin/cvsweb/src/usr.bin/nc/
Packager: Dmitry V. Levin <ldv@altlinux.org>

#  Sources are taken and packaged by following command:
#     CVSROOT=anoncvs@anoncvs2.de.openbsd.org:/cvs cvs get src/usr.bin/nc                                      
#     tar czf netcat-$(date +%%Y%%m%%d).tar.gz src/
#  Note: replace double percents in date arguments above by single percent sign.
Source: %name-%datestamp.tar
Patch1: netcat-4.0.20100725-owl-alt-linux.patch
Patch2: netcat-4.0.20100725-owl-ipv4-default.patch
Patch3: netcat-4.0.20100725-owl-alt-fixes.patch
Patch4: netcat-4.0.20100725-alt-usage.patch
Patch5: netcat-4.0.20100725-alt-bsdsockopts.patch
Patch6: netcat-4.0.20100725-alt-rpp.patch
Patch7: netcat-4.0.20100725-alt-strtonum.patch
Patch8: netcat-4.0.20100725-alt-execcmd.patch
Patch9: netcat-4.0.20100725-alt-proxy_pass.patch
Patch10: netcat-4.0.20100725-alt-warnings.patch
Patch11: netcat-4.0.20100725-jzeleny-pollhup.patch

Obsoletes: nc
Provides: nc
Conflicts: nedit < 5.5-alt3

%description
This package contains netcat, a simple utility for reading and writing
data across network connections, using the TCP or UDP protocols.
netcat is intended to be a reliable back-end tool which can be used
directly or easily driven by other programs and scripts.  netcat is
also a feature-rich network debugging and exploration tool, since
it can create many different connections and has many built-in
capabilities.

There are three well-known netcat implementations, see here for
details: http://pintday.org/downloads/netcat/. This package contains
OpenBSD utility with improvements from Openwall project.

%define srcdir src/usr.bin/nc

%prep
%setup -q -c
cd src
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
sed -i 's,\mnc\M,netcat,' usr.bin/nc/nc.1

%build
%make_build -C %srcdir CFLAGS="-c $RPM_OPT_FLAGS $(getconf LFS_CFLAGS)"

%install
install -pD -m755 %srcdir/nc   %buildroot%_bindir/netcat
install -pD -m644 %srcdir/nc.1 %buildroot%_man1dir/netcat.1
ln -s netcat %buildroot%_bindir/nc
ln -s netcat.1 %buildroot%_man1dir/nc.1

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%files
%_bindir/*
%_mandir/man?/*

%changelog
