Name: netpbm
Version: 10.85.04
Release: alt1

Summary: Tools for manipulating graphics files in netpbm supported formats
License: BSD-like
Group: Graphics

Url: http://netpbm.sourceforge.net

# Source-url: https://github.com/t6/netpbm/archive/v10.85.04.tar.gz
Source: %name-%version.tar

Requires: lib%{name}11 = %EVR

BuildRequires: flex libjasper-devel libjbig-devel >= 2.0
BuildRequires: libjpeg-devel libpng-devel libtiff-devel libxml2-devel libX11-devel

%package -n lib%{name}11
Summary: A library for handling different graphics file formats
Group: System/Libraries
Requires: xorg-x11-rgb
Provides: libnetpbm = %version-%release

%package -n lib%name-devel
Summary: A library for handling different graphics file formats
Group: Development/C
Requires: lib%{name}11 = %EVR

%package -n lib%name-devel-static
Summary: A library for handling different graphics file formats
Group: Development/C
Requires: lib%name-devel = %EVR

%description
The netpbm package contains programs for handling various graphics file
formats, including .pbm (portable bitmaps), .pgm (portable graymaps),
.pnm (portable anymaps), .ppm (portable pixmaps) and others.

%description -n lib%{name}11
This package contains a library of functions which support programs for
handling various graphics file formats, including .pbm (portable bitmaps),
.pgm (portable graymaps), .pnm (portable anymaps), .ppm (portable pixmaps)
and others.

%description -n lib%name-devel
This package contains the header files and programmer's documentation
for developing programs which can handle the various graphics file
formats supported by the netpbm library.

%description -n lib%name-devel-static
This package contains the static library for developing statically linked
programs which can handle the various graphics file formats supported by
the netpbm library.

%prep
%setup
# use system jasper library
rm -rf converter/other/jpeg2000/libjasper/
# use system jbig library
rm -rf converter/other/jbig/libjbig/

# hide nss-utils require (ALT bug 29475)
subst "s| atob| a= atob|" converter/other/anytopnm

# rename conflicting functions and variables
#sed -i 's/\<getline\>/ppm_&/g' converter/ppm/xpmtoppm.c

%build
cat <<__EOF__ >lib/compile.h
#define COMPILE_TIME "The same time"
#define COMPILED_BY "%packager, %vendor"
__EOF__

cp -av config.mk.in config.mk
cat <<__EOF__ >>config.mk
#
# ALT
#
DEFAULT_TARGET = nonmerge
NETPBMLIBTYPE=unixshared
NETPBMLIBSUFFIX=so
#STATICLIB_TOO=N
CFLAGS = %optflags -D_GNU_SOURCE
CFLAGS_SHLIB = %optflags_shared

LDRELOC = ld --reloc
LINKER_CAN_DO_EXPLICIT_LIBRARY=Y
LINKERISCOMPILER = Y

CC = gcc
SHLIB_CLIB = -lm
TIFFLIB = libtiff.so
JPEGLIB = libjpeg.so
ZLIB = libz.so

JBIGHDR_DIR = %_includedir
JBIGLIB = %_libdir/libjbig.so

JASPERHDR_DIR = %_includedir/jasper
JASPERLIB = %_libdir/libjasper.so

STRIPFLAG =
pkgdir = %buildroot%prefix

PNGHDR_DIR = USE_PKG_CONFIG.a
PNGLIB = USE_PKG_CONFIG.a
X11HDR_DIR = USE_PKGCONFIG.a
X11LIB = USE_PKGCONFIG.a
NETPBM_DOCURL = http://netpbm.sourceforge.net/doc/
#WANT_SSE = Y

__EOF__

%make_build

%install
%make_install install.bin install.data install.hdr
mkdir -p %buildroot%_libdir %buildroot%_datadir
%if_enabled static
cp -av lib/lib%name.a %buildroot%_libdir
%endif
cp -av lib/lib%name.so* %buildroot%_libdir

mv %buildroot%prefix/misc %buildroot%_datadir/%name
rm -fv %buildroot%_bindir/manweb

# install netpbm-config
sed	-e '/^@/d'				\
	-e 's|@VERSION@|%version|'		\
	-e 's|@DATADIR@|%_datadir/%name|'	\
	-e 's|@LINKDIR@|%_libdir|'		\
	-e 's|@INCLUDEDIR@|%_includedir/netpbm|'	\
	-e 's|@BINDIR@|%_bindir|'		\
		buildtools/config_template >%buildroot%_bindir/netpbm-config
egrep '@[A-Z]+@' %buildroot%_bindir/netpbm-config && exit 1
chmod +x %buildroot%_bindir/netpbm-config
test "$(%buildroot%_bindir/netpbm-config --datadir)" = %_datadir/%name

mkdir -p %buildroot%_man1dir
install -p -m644 man/*.1 %buildroot%_man1dir

%files -n lib%{name}11
%_libdir/lib%name.so.11
%_libdir/lib%name.so.11.*
%doc doc/copyright_summary doc/COPYRIGHT.PATENT README

%files -n lib%name-devel
%_libdir/lib%name.so
%dir %_includedir/netpbm/
%_includedir/netpbm/*.h
#_man3dir/*.*
%doc doc/Netpbm.programming

%files
%_bindir/*
%_man1dir/*.*
#_man5dir/*.*
%_datadir/%name/
%doc doc/HISTORY

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif

%changelog
