%define _unpackaged_files_terminate_build 1

Name: ntp
Version: 4.2.8p18
Release: alt1
%define srcname %name-%version%{?patchlevel:%patchlevel}

Summary: The Network Time Protocol (NTP)
License: GPL-3.0-or-later
Group: System/Configuration/Other
Url: http://www.ntp.org/

Source0: http://www.eecis.udel.edu/~ntp/ntp_spool/ntp4/ntp-4.2/%srcname.tar.gz
Source1: ntpd.init
Source2: ntpd.sysconfig
Source3: %name.conf
Source4: %name.keys

Source11: ntp.1
Source12: ntpd.8
Source13: ntpdate.8
Source14: ntpsweep.8

Source21: chrooted-ntpd.all
Source22: chrooted-ntpd.conf
Source23: chrooted-ntpd.lib

Patch1: %name-4.2.6p5-alt-compile-dirty-hack-NANO.patch
Patch2: %name-4.2.8p14-MD5-to-SHA1-default.patch
Patch3: %name-4.2.8p18-bug3926-gcc14.patch

Requires: ntp-doc = %version-%release
Requires: ntp-utils = %version-%release
Requires: ntpdate = %version-%release
Requires: ntpd = %version-%release

# ntpq subpackage should not have dependency to ntp-utils subpackage:
# man8/ntpq.8 is a symlink to man1/ntp.1 which in ntp-utils
%add_findreq_skiplist %_man8dir/ntpq.*

BuildRequires: zlib-devel

# due to readline library linked with tinfo.
BuildPreReq: libreadline-devel >= 4.3-alt5

# due to ntp_drop_priv.
BuildRequires: libcap-devel

# ntp_crypto_rnd.c:93: undefined reference to `arc4random_buf'
BuildRequires: libssl-devel
# https://bugzilla.altlinux.org/38287
%(rpmquery --qf 'Requires: libcrypto = %%{VERSION}' libssl-devel)

# for sbin/update-leap
BuildRequires: perl-File-Fetch perl-Digest-SHA perl-HTTP-Tiny perl-Net-SSLeay perl-IO-Socket-SSL

# https://bugzilla.altlinux.org/39775
BuildRequires: pps-tools-devel

# Root directory for chrooted environment, must not be same as real system root.
%define ROOT /var/lib/ntpd

%define common_description The Network Time Protocol (NTP) is used to synchronize the time\
of a computer client or server to another server or reference time\
source, such as a radio or satellite receiver or modem. It provides\
client accuracies typically within a millisecond on LANs and up to\
a few tens of milliseconds on WANs.\
\
Binaries was built with a source code under various free licenses.

%package aux
Summary: The Network Time Protocol (NTP) auxiliary package
Group: System/Configuration/Other
Conflicts: ntp < 4.1.1b
BuildArch: noarch

%package doc
Summary: The Network Time Protocol (NTP) documentation
Group: Development/Other
Requires: ntp-aux = %version-%release
BuildArch: noarch

%package -n perl-NTP-Util
Summary: Perl NTP module
Group: Development/Perl
BuildArch: noarch

%package utils
Summary: The Network Time Protocol (NTP) utilities
Group: System/Base
Requires: ntpdate = %version-%release
Requires: ntpq = %version-%release

%package -n ntpdate
Summary: Set the date and time via NTP
Group: System/Base
Requires: ntp-aux = %version-%release
Requires(pre): shadow-utils
Requires: /var/empty

%package -n ntpq
Summary: The standard NTP query program
Group: System/Base

%package -n ntpd
Summary: The Network Time Protocol daemon
Group: System/Servers
Obsoletes: xntp3
Requires(pre): shadow-utils
Requires(pre): service, coreutils
# due to ntp_intres.
Requires: /var/resolv
Provides: ntp-server

%description
%common_description

%description aux
%common_description

This is an auxiliary package.

%description doc
%common_description

This package contains NTP documentation.

%description -n perl-NTP-Util
Perl NTP module

%description utils
%common_description

This package contains various NTP utilities.

%description -n ntpdate
%common_description

This package contains ntpdate program for retrieving the date and time
from remote machines via a network.

%description -n ntpq
%common_description

This package contains standard NTP query program

%description -n ntpd
%common_description

This package contains Network Time Protocol daemon.

%prep
%setup -n %srcname
%ifarch %e2k
sed -i 's,-Wnormalized=id,,' sntp/libevent/configure*
%endif

#patch1 -p1
%patch2 -p2
%patch3 -p1

# Fix progname initialization when argc==0.
fgrep -rl --include='*.c' 'progname = argv[0];' . |
	xargs grep -l 'main *(' |
	while read f; do
		n="${f##*/}"
		n="${n%%.c}"
		subst 's/progname = argv\[0\];/progname = argc ? argv[0] : "PROGNAME";/' "$f"
		subst "s/PROGNAME/$n/" "$f"
	done

install -p -m644 %SOURCE2 ntpd.sysconfig
install -p -m644 $RPM_SOURCE_DIR/{ntp.1,{ntpd,ntpdate,ntpsweep}.8} .

find -type f -print0 |
	xargs -r0 grep -FZl '@ROOT@' -- |
	xargs -r0 sed -i 's,@ROOT@,%ROOT,g' --

# https://lists.altlinux.org/pipermail/devel/2024-November/218948.html
sed -i "/test-realpath/d" tests/libntp/Makefile.am

%build
%add_optflags -D_GNU_SOURCE
%define _bindir %_sbindir

%autoreconf
%configure \
	--enable-ntp-signd \
	--enable-linuxcaps \
	--without-readline
echo '#define HAVE_LIBREADLINE 1' >>config.h

%make_build

%check
# https://lists.altlinux.org/pipermail/devel/2020-March/210366.html
%ifnarch ppc64le
make check
%endif

%install
make DESTDIR=$RPM_BUILD_ROOT perllibdir=%perl_vendor_privlib install

install -p -m755 scripts/ntpsweep/ntpsweep $RPM_BUILD_ROOT%_sbindir/

# Manpages.
%set_compress_method skip
mkdir -p $RPM_BUILD_ROOT{%_man1dir,%_man8dir}
#__install -p -m644 ntp.1 $RPM_BUILD_ROOT%_man1dir/
sed "s|@VERSION@|%version|" < ntp.1 > $RPM_BUILD_ROOT%_man1dir/ntp.1
install -p -m644 {ntpd,ntpdate,ntpsweep}.8 $RPM_BUILD_ROOT%_man8dir/
find $RPM_BUILD_ROOT%_mandir -type f -regex '.*\.[1-8]$' -print0 | xargs -r0 bzip2 -9
for f in $RPM_BUILD_ROOT%_sbindir/*; do
	t="$RPM_BUILD_ROOT%_man8dir/${f##*/}.8.bz2"
	[ -f "$t" ] || ln -s ../man1/ntp.1.bz2 "$t"
done

# Docs.
%define docdir %_docdir/%name-%version
mkdir -p $RPM_BUILD_ROOT%docdir
mv $RPM_BUILD_ROOT%_docdir/ntp  $RPM_BUILD_ROOT%docdir
mv $RPM_BUILD_ROOT%_docdir/sntp $RPM_BUILD_ROOT%docdir
cp -a COPYRIGHT NEWS TODO WHERE-TO-START README.bk README.hackers README.refclocks README.versions \
	$RPM_BUILD_ROOT%docdir/

install -pD -m755 %SOURCE1 $RPM_BUILD_ROOT%_initdir/ntpd
install -pD -m644 ntpd.sysconfig $RPM_BUILD_ROOT%_sysconfdir/sysconfig/ntpd
install -pD -m600 %SOURCE3 $RPM_BUILD_ROOT%_sysconfdir/%name.conf

# Prepare for chroot
mkdir -p $RPM_BUILD_ROOT%ROOT/tmp
mkdir -p $RPM_BUILD_ROOT%ROOT/%_lib
install -pD -m600 %SOURCE4 $RPM_BUILD_ROOT%ROOT%_sysconfdir/%name/keys
touch $RPM_BUILD_ROOT%ROOT%_sysconfdir/%name/{drift,step-tickers}
ln -s ..%ROOT%_sysconfdir/%name $RPM_BUILD_ROOT%_sysconfdir/
# scripts for update_chrooted
mkdir -p $RPM_BUILD_ROOT%_sysconfdir/chroot.d
install -pD -m700 %SOURCE21 $RPM_BUILD_ROOT%_sysconfdir/chroot.d/ntpd.all
install -pD -m700 %SOURCE22 $RPM_BUILD_ROOT%_sysconfdir/chroot.d/ntpd.conf
install -pD -m700 %SOURCE23 $RPM_BUILD_ROOT%_sysconfdir/chroot.d/ntpd.lib
# ghost files from update_chrooted
touch $RPM_BUILD_ROOT%ROOT%_sysconfdir/host.conf
touch $RPM_BUILD_ROOT%ROOT%_sysconfdir/hosts
touch $RPM_BUILD_ROOT%ROOT%_sysconfdir/localtime
touch $RPM_BUILD_ROOT%ROOT%_sysconfdir/nsswitch.conf
touch $RPM_BUILD_ROOT%ROOT%_sysconfdir/resolv.conf
touch $RPM_BUILD_ROOT%ROOT%_sysconfdir/services
touch $RPM_BUILD_ROOT%ROOT/%_lib/libnsl.so.1
touch $RPM_BUILD_ROOT%ROOT/%_lib/libnss_dns.so.2
touch $RPM_BUILD_ROOT%ROOT/%_lib/libnss_files.so.2
touch $RPM_BUILD_ROOT%ROOT/%_lib/libresolv.so.2

%define r_dir %ROOT%_sysconfdir/%name
%define r_link %_sysconfdir/%name

%pre -n ntpdate
/usr/sbin/groupadd -r -f ntpd
/usr/sbin/useradd -r -g ntpd -d /dev/null -s /dev/null -N ntpd >/dev/null 2>&1 ||:

%pre -n ntpd
/usr/sbin/groupadd -r -f ntpd
/usr/sbin/useradd -r -g ntpd -d /dev/null -s /dev/null -N ntpd >/dev/null 2>&1 ||:
f=%r_link
if [ -d "$f" -a ! -L "$f" ]; then
	%__rm -rf "$f"
	/bin/touch "$f.RPMLOCK"
fi

%post -n ntpd
%_sysconfdir/chroot.d/ntpd.all
if [ $1 = 1 ]; then
        /sbin/chkconfig --add ntpd
fi
d=%r_dir
f=%r_link
if [ -f "$f.RPMLOCK" -a -d "$f" -a ! -d "$d.RPMSAVE" ]; then
	%__mv "$d" "$d.RPMSAVE"
	%__rm -f "$f.RPMLOCK"
else
	/sbin/service ntpd condrestart ||:
fi

%preun -n ntpd
%preun_service ntpd

%triggerpostun -n ntpd -- %name < 4.1.1b
d=%r_dir
if [ -d "$d.RPMSAVE" -a ! -d "$d" ]; then
	%__mv "$d.RPMSAVE" "$d"
	/sbin/service ntpd condrestart ||:
fi

%files

%files aux

%files doc
%dir %docdir
%docdir/ntp
%docdir/sntp
%docdir/[A-Z]*

%files -n perl-NTP-Util
%dir %perl_vendor_privlib/NTP
%perl_vendor_privlib/NTP/Util.pm

%files utils
%_sbindir/*
%_mandir/man?/*
%exclude %_sbindir/ntpd
%exclude %_sbindir/ntpq
%exclude %_sbindir/ntpdate
%exclude %_man1dir/ntpd.*
%exclude %_man1dir/ntpq.*
%exclude %_man8dir/ntpd.*
%exclude %_man8dir/ntpq.*
%exclude %_man8dir/ntpdate.*

%files -n ntpdate
%_sbindir/ntpdate
%_man8dir/ntpdate.*

%files -n ntpq
%_sbindir/ntpq
%_man1dir/ntpq.*
%_man8dir/ntpq.*

%files -n ntpd
%config %_initdir/ntpd
%config(noreplace) %_sysconfdir/sysconfig/ntpd
%config(noreplace) %_sysconfdir/%name.conf
%_sysconfdir/%name
%_sysconfdir/chroot.d/ntpd.*
%_sbindir/ntpd
%_man1dir/ntpd.*
%_man8dir/ntpd.*

%defattr(640,root,ntpd,710)
%dir %ROOT
%dir %ROOT%_sysconfdir
%dir %ROOT/%_lib
%attr(1770,root,ntpd) %dir %ROOT/tmp
%attr(1770,root,ntpd) %dir %ROOT%_sysconfdir/%name
%config(noreplace) %ROOT%_sysconfdir/%name/keys
%config(noreplace) %verify(not md5 size mtime) %ROOT%_sysconfdir/%name/step-tickers
%attr(640,ntpd,ntpd) %ghost %ROOT%_sysconfdir/%name/drift

# ghost files from update_chrooted
%ghost %ROOT%_sysconfdir/host.conf
%ghost %ROOT%_sysconfdir/hosts
%ghost %ROOT%_sysconfdir/localtime
%ghost %ROOT%_sysconfdir/nsswitch.conf
%ghost %ROOT%_sysconfdir/resolv.conf
%ghost %ROOT%_sysconfdir/services
%ghost %ROOT/%_lib/libnsl.so.1
%ghost %ROOT/%_lib/libnss_dns.so.2
%ghost %ROOT/%_lib/libnss_files.so.2
%ghost %ROOT/%_lib/libresolv.so.2

%changelog
