%define Nif_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define Nif_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define Nif_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define Nif_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%define tbname         NVIDIA-Linux-x86_64
%ifarch aarch64
%define tbname         NVIDIA-Linux-aarch64
%endif
%define bin_pkg_name     nvidia_glx
%define module_name    nvidia
%define dirsuffix %nil
%ifarch x86_64
#define dirsuffix -no-compat32
%endif

%define gl_libver 1.7.0
%define egl_libver 1.1.0
%define gbm_ver %{get_version libgbm-devel}

# version-release
%define nv_version 535
%define nv_release 86
%define nv_minor   05
%define pkg_rel alt253
%define nv_version_full %{nv_version}.%{nv_release}.%{nv_minor}
%if "%nv_minor" == "%nil"
%define nv_version_full %{nv_version}.%{nv_release}
%endif

%Nif_ver_gteq %ubt_id M90
%def_enable glvnd
%else
%def_disable glvnd
%endif
#
%ifarch %ix86
%def_disable kernelsource
%define subd ./32
%else
%def_enable kernelsource
%define subd ./
%endif
#
%def_disable package_wfb

%define tbver %nv_version_full
%define module_version	%nv_version%nv_release%nv_minor
%define module_release	%pkg_rel

%define myGroup System/Kernel and hardware
%define mySummary NVIDIA drivers and OpenGL libraries for XOrg X-server
%define mySummaryRu Драйверы NVIDIA и библиотеки OpenGL для Х-сервера XOrg
%define myUrl http://www.nvidia.com
%define myVendor NVIDIA Corp.
%define myLicense NVIDIA

%define mods /modules
%define exts /modules/extensions
%define drvs /modules/drivers
%define lib_sym_dir %_sysconfdir/X11/%_lib
%define nv_lib_sym_dir %{lib_sym_dir}_nvidia
%define nv_lib32_sym_dir %_sysconfdir/X11/lib_nvidia
%define xdrv_d /usr/libexec/X11/drv.d
%define xdrv_d_old /usr/X11R6/lib/drv.d
%define xdrv_pre_d /usr/libexec/X11/drvpre.d
%define xdrv_pre_d_old /usr/X11R6/lib/drvpre.d

%define xinf_dir %_datadir/hwdatabase/videoaliases/
%define nv_workdirdir %_localstatedir/nvidia
%define tls_lib_dir %_libdir
%define x11_lib_dir %_libdir
%define x11_lib_old /usr/X11R6/lib
%define x11_mod_dir /usr/%_lib/X11%mods
%define x11_mod_old /usr/X11R6/%_lib%mods
%define x11_drv_dir /usr/%_lib/X11%drvs
%define x11_drv_old /usr/%_lib/X11%drvs
%define x11_ext_dir /usr/%_lib/X11%exts
%define x11_ext_old /usr/X11R6/%_lib%exts
%define x11driver_dir %_libdir/X11
%define nv_lib_dir_prefix %_libdir/nvidia_
%define nv_lib_dir_prefix_old /usr/X11R6/%_lib/nvidia_
%define nv_lib_dir %nv_lib_dir_prefix%tbver

#add_findreq_skiplist %nv_lib_dir/
%add_findreq_skiplist %x11_lib_old/*
%add_findreq_skiplist %_bindir/nvidia-bug-report*.sh
%filter_from_requires /^libEGL_nvidia\.so\./d

Name: nvidia_glx_src_%nv_version_full
Version: %nv_version_full
Release: %pkg_rel

Source0: null
Source201: ftp://download.nvidia.com/XFree86/Linux-x86_64/%tbver/NVIDIA-Linux-x86_64-%tbver.run
Source202: ftp://download.nvidia.com/XFree86/Linux-aarch64/%tbver/NVIDIA-Linux-aarch64-%tbver.run

Source2: nvidia.xinf
Source100: nvidia_create_xinf

Patch1: alt-fix-build-kernel.patch
Patch2: alt-ignore-dma-remap.patch
#
Patch4: kernel-5.11-aarch64.patch
Patch5: kernel-5.13-aarch64.patch

BuildRequires(pre): rpm-build-ubt libgbm-devel
BuildRequires: rpm-build-kernel rpm-macros-alternatives
BuildRequires: libXext-devel libEGL-devel egl-wayland-devel
BuildRequires: libwayland-client-devel libwayland-server-devel
BuildRequires: libGLdispatch libGLX
ExclusiveArch: x86_64 %ix86 aarch64


Group: %myGroup
Summary: %mySummary
Summary(ru_RU.UTF-8): %mySummaryRu
Url: %myUrl
License: %myLicense
%description
Sources for %{bin_pkg_name}_%{version} package


%package -n %{bin_pkg_name}_%{version}
Requires(pre): %{bin_pkg_name}_common >= %version
Requires(post): x11presetdrv
%Nif_ver_gteq %gbm_ver 21.2
Requires: libnvidia-egl-gbm >= 0
%endif
Requires: firmware-%module_name-%version = %version
#
Group: %myGroup
Summary: %mySummary
Summary(ru_RU.UTF-8): %mySummaryRu
Url: %myUrl
License: %myLicense
%description -n %{bin_pkg_name}_%{version}
NVIDIA X11 drivers and OpenGL libraries for GeForce/Quadro
based video cards.
%description -n %{bin_pkg_name}_%{version} -l ru_RU.UTF-8
Драйверы и OpenGL-библиотеки для X11 и видеокарт NVIDIA на базе
GeForce/Quadro.

%package -n kernel-source-%module_name-%module_version
Group: Development/Kernel
Summary: Linux %module_name modules sources
License: %myLicense
Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>
%description -n kernel-source-%module_name-%module_version
%module_name modules sources for Linux kernel

%package -n firmware-%module_name-%version
Group: Development/Kernel
Summary: Firmware for NVIDIA video devices.
License: %myLicense
Requires: %{bin_pkg_name}_common >= %version
Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>
%description -n firmware-%module_name-%version
This package provides the firmware to drive the GSP.
The GPU System Processor (GSP) was first introduced in the Turing
architecture and supports accelerating tasks traditionally performed
by the driver on the CPU.

%prep
%setup -T -c -n %tbname-%tbver%dirsuffix
rm -rf %_builddir/%tbname-%tbver%dirsuffix
cd %_builddir
%ifarch aarch64
sh %SOURCE202 -x
%else
sh %SOURCE201 -x
%endif
cd %tbname-%tbver%dirsuffix

pushd kernel
#%patch1 -p1
%patch2 -p1
#
%ifarch aarch64
%patch4 -p1
%patch5 -p1
%endif
rm -rf precompiled
%ifarch aarch64
#fgrep -rl MT_DEVICE_GRE |xargs sed -i s,MT_DEVICE_GRE,MT_NORMAL_NC,
sed -ri '/NV_ASM_SET_MEMORY_H_PRESENT/atypedef _Bool bool;' conftest.sh
%endif
popd

%build


%install
%set_verify_elf_method textrel=relaxed
%brp_strip_none %_libdir/*
%brp_strip_none %nv_lib_dir/*

soname()
{
    readelf -a $1| grep SONAME| sed 's/.*\[//'| sed 's/\].*//'
}

%__mkdir_p %buildroot/%_sbindir
%__mkdir_p %buildroot/%tls_lib_dir
%__mkdir_p %buildroot/%nv_lib_dir
%__mkdir_p %buildroot/%x11_mod_dir
#%__mkdir_p %buildroot/%x11_mod_old
%__mkdir_p %buildroot/%x11_drv_dir
#%__mkdir_p %buildroot/%x11_drv_old
%__mkdir_p %buildroot/%x11_ext_dir
#%__mkdir_p %buildroot/%x11_ext_old
%__mkdir_p %buildroot/%lib_sym_dir
%__mkdir_p %buildroot/%nv_lib_sym_dir
%__mkdir_p %buildroot/%nv_lib32_sym_dir
%__mkdir_p %buildroot/%xdrv_d
#%__mkdir_p %buildroot/%xdrv_d_old
%__mkdir_p %buildroot/%xdrv_pre_d
%__mkdir_p %buildroot/%xinf_dir
%__mkdir_p %buildroot/%nv_workdirdir
%__mkdir_p %buildroot/%_datadir/nvidia/


# install libraries
%__install -m 0644 %subd/libnvidia-glvkspirv.so.%tbver %buildroot/%_libdir/
%__install -m 0644 %subd/libnvidia-glcore.so.%tbver %buildroot/%_libdir/
%__install -m 0644 %subd/libnvidia-eglcore.so.%tbver %buildroot/%_libdir/
%__install -m 0644 %subd/libnvidia-glsi.so.%tbver %buildroot/%_libdir/
%__install -m 0644 %subd/libnvidia-tls.so.%tbver %buildroot/%_libdir/
%ifarch x86_64
#%__install -m 0644 %subd/libnvidia-pkcs11.so.%tbver %buildroot/%_libdir/
#%__install -m 0644 %subd/libnvidia-pkcs11-openssl3.so.%tbver %buildroot/%_libdir/
%endif
%ifnarch aarch64
#%__install -m 0644 %subd/libnvidia-compiler.so.%tbver %buildroot/%_libdir/
%endif
%ifnarch %ix86 armh
%__install -m 0644 %subd/libnvidia-rtcore.so.%tbver %buildroot/%_libdir/
%__install -m 0644 %subd/libnvidia-vulkan-producer.so.%tbver %buildroot/%_libdir/
%endif
%ifnarch %ix86 aarch64 armh
%__install -m 0644 %subd/libnvidia-wayland-client.so.%tbver %buildroot/%_libdir/
%endif
#

install -m 0644 %SOURCE2 %buildroot/%nv_lib_dir/nvidia.xinf
ln -sr %buildroot/%nv_lib_dir/nvidia.xinf %buildroot/%nv_lib_sym_dir/nvidia.xinf
ln -sr %buildroot/%nv_lib_dir/nvidia.xinf %buildroot/%xinf_dir/nvidia-%version.xinf

%ifarch x86_64 aarch64
%__install -m 0644 %subd/nvidia_drv.so %buildroot/%nv_lib_dir/
%endif

%if_enabled package_wfb
[ -f %subd/libnvidia-wfb.so.%tbver ] && \
%__install -m 0644 %subd/libnvidia-wfb.so.%tbver %buildroot/%nv_lib_dir/libwfb.so
%endif

%ifarch x86_64 aarch64
%__install -m 0644 %subd/libglxserver_nvidia.so.%tbver %buildroot/%nv_lib_dir/libglxserver_nvidia.so
%endif

%__install -m 0644 %subd/libGLdispatch.so.0  %buildroot/%nv_lib_dir/libGLdispatch.so
#
%if_enabled glvnd
%__install -m 0644 %subd/libGL.so.%gl_libver  %buildroot/%nv_lib_dir/libGL.so
%__install -m 0644 %subd/libEGL.so.%egl_libver  %buildroot/%nv_lib_dir/libEGL.so
%else
%__install -m 0644 %subd/libGL.so.%tbver  %buildroot/%nv_lib_dir/libGL.so
%__install -m 0644 %subd/libEGL.so.%tbver  %buildroot/%nv_lib_dir/libEGL.so
%endif
#
%__install -m 0644 %subd/libEGL_nvidia.so.%tbver    %buildroot/%nv_lib_dir/libEGL_nvidia.so
ln -sr %buildroot/%nv_lib_dir/libEGL_nvidia.so %buildroot/%_libdir/libEGL_nvidia.so.0
%__install -m 0644 %subd/libGLESv2.so.2.1.0  %buildroot/%nv_lib_dir/libGLESv2.so
%__install -m 0644 %subd/libGLESv2_nvidia.so.%tbver %buildroot/%nv_lib_dir/libGLESv2_nvidia.so
%__install -m 0644 %subd/libGLESv1_CM.so.1.2.0  %buildroot/%nv_lib_dir/libGLESv1_CM.so
%__install -m 0644 %subd/libGLESv1_CM_nvidia.so.%tbver %buildroot/%nv_lib_dir/libGLESv1_CM_nvidia.so
%__install -m 0644 %subd/libGLX.so.0  %buildroot/%nv_lib_dir/libGLX.so
%__install -m 0644 %subd/libGLX_nvidia.so.%tbver    %buildroot/%nv_lib_dir/libGLX_nvidia.so
%__install -m 0644 %subd/libnvidia-allocator.so.%tbver    %buildroot/%nv_lib_dir/libnvidia-allocator.so
%ifnarch %ix86 armh
ln -sr %buildroot/%_libdir/libnvidia-vulkan-producer.so.%tbver %buildroot/%nv_lib_dir/libnvidia-vulkan-producer.so
%endif

%__install -m 0644 %subd/libvdpau_nvidia.so.%tbver %buildroot/%nv_lib_dir/libvdpau_nvidia.so
%ifarch x86_64 aarch64
%__install -m 0644 %subd/libnvidia-cfg.so.%tbver %buildroot/%nv_lib_dir/libnvidia-cfg.so
%endif
/sbin/ldconfig -n %buildroot/%nv_lib_dir

%ifarch x86_64
mkdir -p %buildroot/%nv_lib_dir/nvidia/wine/
install -m 0755 *nvngx.dll %buildroot/%nv_lib_dir/nvidia/wine/
%endif

%__install -m 0644 nvidia-application-profiles-%version-rc \
    %buildroot/%_datadir/nvidia/nvidia-application-profiles-%version-rc
%__install -m 0644 nvidia-application-profiles-%version-key-documentation \
    %buildroot/%_datadir/nvidia/nvidia-application-profiles-%version-key-documentation

mkdir -p %buildroot/%_datadir/glvnd/egl_vendor.d/
install -m 0644 10_nvidia.json %buildroot/%_datadir/glvnd/egl_vendor.d/%{version}_nvidia.json
mkdir -p %buildroot/%_datadir/egl/egl_external_platform.d
install -m 0644 10_nvidia_wayland.json %buildroot/%_datadir/egl/egl_external_platform.d/%{version}_nvidia_wayland.json
mkdir -p %buildroot/%_datadir/vulkan/icd.d/
NVIDIA_ICD_JSON="nvidia_icd.json.template"
[ -e "$NVIDIA_ICD_JSON" ] || NVIDIA_ICD_JSON="nvidia_icd.json"
install -m 0644 "$NVIDIA_ICD_JSON" %buildroot/%_datadir/vulkan/icd.d/%{version}_nvidia_icd.json
%if_enabled glvnd
sed -i '/\"library_path\"/s|\"library_path\".*:.*\".*\"|"library_path": "libGLX_nvidia.so.0"|' %buildroot/%_datadir/vulkan/icd.d/%{version}_nvidia_icd.json
%else
sed -i '/\"library_path\"/s|\"library_path\".*:.*\".*\"|"library_path": "libGL.so.1"|' %buildroot/%_datadir/vulkan/icd.d/%{version}_nvidia_icd.json
%endif
mkdir -p %buildroot/%_datadir/vulkan/implicit_layer.d/
install -m 0644 nvidia_layers.json %buildroot/%_datadir/vulkan/implicit_layer.d/%{version}_nvidia_layers.json

%if_enabled kernelsource
# kernel-source install
%__rm -rf kernel-source-%module_name-%module_version/
%__mkdir_p %buildroot/%_usrsrc/kernel/sources/ kernel-source-%module_name-%module_version/
%__cp -ar kernel/* kernel-source-%module_name-%module_version/
%__cp LICENSE kernel-source-%module_name-%module_version/
tar -c kernel-source-%module_name-%module_version | bzip2 -c > \
    %buildroot%_usrsrc/kernel/sources/kernel-source-%module_name-%module_version.tar.bz2
%endif

# install firmware
mkdir -p %buildroot/lib/firmware/nvidia/%version/
install firmware/gsp*.bin %buildroot/lib/firmware/nvidia/%version/

# install scripts
mkdir -p %buildroot/%_bindir
install -m 0755 nvidia-bug-report.sh %buildroot/%_bindir/nvidia-bug-report-%version.sh
mkdir -p %buildroot/%_altdir/
cat > %buildroot/%_altdir/%name <<__EOF__
%_bindir/nvidia-bug-report.sh %_bindir/nvidia-bug-report-%version.sh %version
__EOF__


%post -n %{bin_pkg_name}_%{version}
# switch nvidia driver and libraries
if [ -z "$DURING_INSTALL" ]; then
    X11PRESETDRV=`which x11presetdrv 2>/dev/null`
    if [ -n "$X11PRESETDRV" ]; then
	$X11PRESETDRV ||:
    else
	echo "Warning! x11presetdrv program not found!" >&2
    fi
fi

%files -n %{bin_pkg_name}_%{version}
%doc LICENSE
%doc html NVIDIA_Changelog README.txt
#
%_libdir/libnvidia-tls.so.%version
%_libdir/libnvidia-glcore.so.%version
%_libdir/libnvidia-eglcore.so.%version
%_libdir/libnvidia-glsi.so.%version
%_libdir/libnvidia-glvkspirv.so.%version
%ifarch x86_64
#%_libdir/libnvidia-pkcs11.so.%version
#%_libdir/libnvidia-pkcs11-openssl3.so.%version
%endif
%ifnarch aarch64
#%_libdir/libnvidia-compiler.so.%version
%endif
%ifnarch %ix86 armh
%_libdir/libnvidia-rtcore.so.%version
%_libdir/libnvidia-vulkan-producer.so.%version
%endif
%ifnarch %ix86 aarch64 armh
%_libdir/libnvidia-wayland-client.so.%version
%endif
%_altdir/%name
%_bindir/nvidia-bug-report-%version.sh
%dir %nv_lib_dir
%ifarch x86_64 aarch64
%nv_lib_dir/nvidia_drv.*
%nv_lib_dir/libglx*
%nv_lib_dir/libnvidia-cfg.so*
%endif
%nv_lib_dir/libGL.so*
%nv_lib_dir/libEGL.so*
%nv_lib_dir/libEGL_nvidia.so*
%nv_lib_dir/libGLESv2.so*
%nv_lib_dir/libGLESv2_nvidia.so*
%nv_lib_dir/libGLESv1_CM.so*
%nv_lib_dir/libGLESv1_CM_nvidia.so*
%nv_lib_dir/libGLX_nvidia.so*
%nv_lib_dir/libGLdispatch.so*
%nv_lib_dir/libGLX.so*
%nv_lib_dir/libvdpau_nvidia.so*
%nv_lib_dir/libnvidia-allocator.so*
%ifnarch %ix86 armh
%nv_lib_dir/libnvidia-vulkan-producer.so*
%endif
%if_enabled package_wfb
%nv_lib_dir/libwfb.so
%nv_lib_dir/libnvidia-wfb.so*
%endif
%ifarch x86_64
%nv_lib_dir/nvidia/
%endif
%nv_lib_dir/nvidia.xinf
%xinf_dir/nvidia-%version.xinf
%_datadir/nvidia/nvidia-application-profiles-%version-rc
%_datadir/nvidia/nvidia-application-profiles-%version-key-documentation
%_datadir/glvnd/egl_vendor.d/%{version}_nvidia.json
%_datadir/vulkan/icd.d/%{version}_nvidia_icd.json
%_datadir/vulkan/implicit_layer.d/%{version}_nvidia_layers.json
%_datadir/egl/egl_external_platform.d/%{version}_nvidia_wayland.json

%files -n firmware-%module_name-%version
/lib/firmware/nvidia/%version/gsp*.bin

%if_enabled kernelsource
%files -n kernel-source-%module_name-%module_version
%_usrsrc/*
%endif

%changelog
