%def_with check
%define ocamlmodule gettext
Name: ocaml-%ocamlmodule
Version: 0.4.2
Release: alt3
Summary: OCaml library for i18n
Group: Development/ML
License: LGPLv2+ with OCaml-LGPL-linking-exception
Url: https://github.com/gildor478/ocaml-gettext
Source: %name-%version.tar
BuildRequires: ocaml-dune-configurator-devel
BuildRequires: ocaml-ocamldoc
BuildRequires: ocaml-cppo
BuildRequires: ocaml-camomile-devel
BuildRequires: ocaml-fileutils-devel >= 0.4.4
BuildRequires: docbook-style-xsl
BuildRequires: xsltproc
BuildRequires: libxml2
%if_with check
BuildRequires: ocaml-ounit-devel
%endif

%description
Ocaml-gettext provides support for internationalization of Ocaml
programs.

Constraints :

* provides a pure Ocaml implementation,
* the API should be as close as possible to GNU gettext,
* provides a way to automatically extract translatable
  strings from Ocaml source code.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %version-%release
Requires: ocaml-fileutils-devel >= 0.4.0

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%dune_build --release @install

%install
%dune_install

%check
find test -type f -name dune -exec sed -i 's,oUnit,ounit2,' {} \;
%dune_check

%files -f ocaml-files.runtime
%doc LICENSE.txt

%files devel -f ocaml-files.devel
%doc README.md CHANGES.md TODO.md
%_bindir/ocaml-gettext
%_bindir/ocaml-xgettext
%_man1dir/*.1*
%_man5dir/*.5*

%changelog
