Name: ocaml-menhir
Version: 20211012
Release: alt1
Summary: LR(1) parser generator for the OCaml programming language.

Group: Development/ML
License: QPL
Url: http://gallium.inria.fr/~fpottier/menhir/
Source: menhir-%version.tar

BuildRequires(pre): ocaml
Provides: ocaml4-menhir = %EVR
Obsoletes: ocaml4-menhir

BuildRequires: dune 

%description
Menhir is a LR(1) parser generator for the OCaml programming language.
That is, Menhir compiles LR(1) grammar specifications down to OCaml
code. Menhir is 90 percent compatible with ocamlyacc. Legacy ocamlyacc
grammar specifications are accepted and compiled by Menhir. The
resulting parsers run and produce correct parse trees. However, parsers
that explicitly invoke functions in module Parsing behave slightly
incorrectly. For instance, the functions that provide access
to positions return a dummy position when invoked by a Menhir parser.
Porting a grammar specification from ocamlyacc to Menhir requires
replacing all calls to module Parsing with new Menhir-specific keywords.

%prep
%setup -q -n menhir-%version

%build
%dune_build --release @install

%install
%dune_install

%files
%doc LICENSE
%_bindir/*
%_man1dir/*
%dir %_libdir/ocaml/menhirLib
%dir %_libdir/ocaml/menhirSdk
%_libdir/ocaml/menhir
%_libdir/ocaml/coq-menhirlib
%_libdir/ocaml/menhirSdk/*
%_libdir/ocaml/menhirLib/*
%_libdir/ocaml/menhirSdk/*

%changelog
