%def_without check
%define modname ocamlgraph
Name: ocaml-%modname
Version: 2.0.0
Release: alt1
Summary: OCaml library for arc and node graphs
Group: Development/ML
License: LGPLv2 with exceptions
Url: http://ocamlgraph.lri.fr/index.en.html
# https://github.com/backtracking/ocamlgraph
Source0: %name-%version.tar
BuildRequires: libart_lgpl-devel
BuildRequires: libgnomecanvas-devel
BuildRequires: dune
BuildRequires: ocaml-ocamldoc
%if_with check
BuildRequires: ocaml-graphics-devel
%endif
BuildRequires(pre): rpm-build-ocaml >= 1.3

%description
Ocamlgraph provides several different implementations of graph data
structures. It also provides implementations for a number of classical
graph algorithms like Kruskal's algorithm for MSTs, topological
ordering of DAGs, Dijkstra's shortest paths algorithm, and
Ford-Fulkerson's maximal-flow algorithm to name a few. The algorithms
and data structures are written functorially for maximal
reusability. Also has input and output capability for Graph Modeling
Language file format and Dot and Neato graphviz (graph visualization)
tools.

%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
sed -i 's,stdlib-shims,,' */dune
%dune_build -p %modname

%install
%dune_install %modname

%check
%dune_check -p %modname

%files -f ocaml-files.runtime
%doc CREDITS FAQ COPYING LICENSE

%files devel -f ocaml-files.devel
%doc CHANGES.md README.md

%changelog
