%def_with doc

Name: offlineimap
Version: 7.3.3
Release: alt3

Summary: Powerful IMAP/Maildir synchronization and reader support

License: GPLv2+
Group: Networking/Mail
Url: http://offlineimap.org/

BuildArch: noarch

# https://github.com/OfflineIMAP/offlineimap.git
# Source-url: %__pypi_url %name
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires: python-module-six python-modules-sqlite3
%if_with doc
BuildRequires: docbook-utils asciidoc-a2x python-module-sphinx-devel
%endif

# it is not a python module
AutoProv:no

%description
OfflineIMAP is a tool to simplify your e-mail reading. With OfflineIMAP,
you can read the same mailbox from multiple computers.  You get a
current copy of your messages on each computer, and changes you make one
place will be visible on all other systems. For instance, you can delete
a message on your home computer, and it will appear deleted on your work
computer as well. OfflineIMAP is also useful if you want to use a mail
reader that does not have IMAP support, has poor IMAP support, or does
not provide disconnected operation.

%prep
%setup -q

## py* -> py2
sed -i 's|#!/usr/bin/env python.*|#!/usr/bin/env python2|' \
    $(find ./ -name '*.py')
sed -i 's|#!/usr/bin/python.*|#!/usr/bin/python2|' \
    $(find ./ -name '*.py')
##

%build
%python_build

%install
%python_install --prefix=%prefix

%if_with doc
%make -C docs man api SPHINXBUILD=sphinx-build
mkdir -p %buildroot/%_man1dir
install -p docs/%name.1 %buildroot/%_man1dir/
%endif

%files
%doc COPYING %name.conf* *.md
%_bindir/%name
%python_sitelibdir/%name/
%python_sitelibdir/%name-%version-py*.egg-info
%if_with doc
%doc docs/html
%_man1dir/%name.1.*
%endif

%changelog
