# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(getopts.pl) swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name ogdi
# TODO: separate gltpd to -server package, add init script (requires portmap)

%define major	4
%define libname lib%{name}%{major}
%define develname lib%{name}-devel

# comment out if not pre-release
#define beta	beta2

# rel for bumping
%define rel	3

Summary:	Open Geographic Datastore Interface
Name:		ogdi
Version:	4.1.0
Release:	alt1_3
License:	BSD
Group:		Sciences/Geosciences
URL:		http://ogdi.sourceforge.net/
Source0:	https://github.com/libogdi/ogdi/releases/download/ogdi_4_1_0/%{name}-%{version}%{?beta:.%beta}.tar.gz
Source1:	http://ogdi.sourceforge.net/ogdi.pdf

Patch1:		ogdi-3.2.0.beta2-fix-str-fmt.patch
#(eatdirt) fix missing links
Patch20:         ogdi-4.0.0-sincos.patch
Patch21:         ogdi-4.0.0-dl.patch

BuildRequires:	pkgconfig(expat)
BuildRequires:	pkgconfig(libtirpc)
BuildRequires:	pkgconfig(tcl)
BuildRequires:	libunixODBC-devel libunixODBC-devel-compat libunixODBC2
BuildRequires:	pkgconfig(zlib)
Source44: import.info

%description
OGDI is the Open Geographic Datastore Interface. OGDI is an
application programming interface (API) that uses a standardized
access methods to work in conjunction with GIS software packages (the
application) and various geospatial data products. OGDI uses a
client/server architecture to facilitate the dissemination of
geospatial data products over any TCP/IP network, and a
driver-oriented approach to facilitate access to several geospatial
data products/formats.

%package -n %{libname}
Summary:	Open Geographic Datastore Interface - library
License:	BSD style
Group:		Sciences/Geosciences

%description -n %{libname}
OGDI is the Open Geographic Datastore Interface. OGDI is an
application programming interface (API) that uses a standardized
access methods to work in conjunction with GIS software packages (the
application) and various geospatial data products. OGDI uses a
client/server architecture to facilitate the dissemination of
geospatial data products over any TCP/IP network, and a
driver-oriented approach to facilitate access to several geospatial
data products/formats.

This package contains just the library required by applications using the
Open Geographic Datastore Interface.

%package -n %{develname}
Summary:	OGDI header files and documentation
Group:		Sciences/Geosciences
Requires:	%{libname} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}

%description -n %{develname}
OGDI header files and developer's documentation.

%package odbc
Summary:	ODBC driver for OGDI
Group:		Sciences/Geosciences
Requires:	%{name} = %{version}-%{release}

%description odbc
ODBC driver for OGDI.

%package -n tcl-ogdi
Summary:	TCL wrapper for OGDI
Summary(pl):	Interfejs TCL do OGDI
Group:		Sciences/Geosciences
Requires:	%{name} = %{version}-%{release}

%description -n tcl-ogdi
TCL wrapper for OGDI.

%prep

%setup -q -n %{name}-%{version}%{?beta:.%beta}
%patch1 -p0
%patch20 -p1 -b .orig
%patch21 -p1 -b .orig

cp -f %{SOURCE1} .

# force system libs
rm -rf proj
rm -rf external/{expat,rpc_win32,zlib}

%build

TOPDIR=`pwd`; TARGET=Linux; export TOPDIR TARGET
INST_LIB=%{_libdir}/;export INST_LIB
export CFG=debug # for -g

# do not compile with ssp. it will trigger internal bugs (to_fix_upstream)
#OPT_FLAGS=`echo $RPM_OPT_FLAGS|sed -e 's/-Wp,-D_FORTIFY_SOURCE=2//g'`
#export CFLAGS="$OPT_FLAGS -fPIC -DPIC -DDONT_TD_VOID -DUSE_TERMIO"
export CFLAGS="%{optflags}"
export LDFLAGS=""
%configure \
	--with-binconfigs \
	--with-expat \
	--with-zlib

# use the generated .mak file ...
cp -af config/linux.mak{,.old}
cp -af config/{L,l}inux.mak

# make doesn't survive a parallell build, so stop that...
make

make -C ogdi/tcl_interface \
	TCL_LINKLIB="-ltcl"

make -C contrib/gdal

make -C ogdi/attr_driver/odbc \
	ODBC_LINKLIB="-lodbc"

%install
# export env
TOPDIR=`pwd`; TARGET=Linux; export TOPDIR TARGET

%makeinstall_std \
	INST_INCLUDE=%{buildroot}%{_includedir}/%{name} \
	INST_LIB=%{buildroot}%{_libdir} \
	INST_BIN=%{buildroot}%{_bindir}

#plugin install
%makeinstall_std -C ogdi/tcl_interface \
	INST_LIB=%{buildroot}%{_libdir}
%makeinstall_std -C contrib/gdal \
	INST_LIB=%{buildroot}%{_libdir}
%makeinstall_std -C ogdi/attr_driver/odbc \
	INST_LIB=%{buildroot}%{_libdir}

# only lib*ogdi* is common library, the rest are dlopened drivers
#mv -f %{buildroot}%{_libdir}/ogdi/*ogdi*.so %{buildroot}%{_libdir}

# remove example binary
rm -rf %{buildroot}%{_bindir}/example?

# we have multilib ogdi-config
%if "%{_lib}" == "lib"
%define cpuarch 32
%else
%define cpuarch 64
%endif

# fix file(s) for multilib issue
touch -r ogdi-config.in ogdi-config

# install pkgconfig file and ogdi-config
mkdir -p %{buildroot}%{_libdir}/pkgconfig
install -p -m 644 ogdi.pc %{buildroot}%{_libdir}/pkgconfig/
install -p -m 755 ogdi-config %{buildroot}%{_bindir}/ogdi-config-%{cpuarch}
# ogdi-config wrapper for multiarch
cat > %{buildroot}%{_bindir}/%{name}-config <<EOF
#!/bin/bash

ARCH=\$(uname -m)
case \$ARCH in
x86_64 | ppc64 | ia64 | s390x | sparc64 | alpha | alphaev6 | aarch64 )
ogdi-config-64 \${*}
;;
*)
ogdi-config-32 \${*}
;;
esac
EOF
chmod 755 %{buildroot}%{_bindir}/%{name}-config
touch -r ogdi-config.in %{buildroot}%{_bindir}/%{name}-config

%files
%doc LICENSE NEWS ChangeLog README
%{_bindir}/gltpd
%{_bindir}/ogdi_*
%dir %{_libdir}/ogdi
%exclude %{_libdir}/%{name}/liblodbc.so
%exclude %{_libdir}/%{name}/libecs_tcl.so
%{_libdir}/%{name}/lib*.so

%files -n %{libname}
%{_libdir}/libogdi.so.%{major}*

%files -n %{develname}
%doc ogdi.pdf
%doc ogdi/examples/example1/example1.c
%doc ogdi/examples/example2/example2.c
%{_bindir}/%{name}-config
%{_bindir}/%{name}-config-%{cpuarch}
%{_libdir}/pkgconfig/%{name}.pc
%dir %{_includedir}/%{name}
%{_includedir}/%{name}/*.h
%{_libdir}/libogdi.so

%files odbc
%{_libdir}/ogdi/liblodbc.so

%files -n tcl-ogdi
%{_libdir}/ogdi/libecs_tcl.so





%changelog
