%define _unpackaged_files_terminate_build 1

# openblas does not build with LTO
%global optflags_lto %nil

%def_without lapack
%ifnarch %e2k
%def_enable dynamic_arch
%endif

%ifarch armh
%define oblas_target ARMV7
%endif
%ifarch aarch64
%define oblas_target ARMV8
%endif
%ifarch riscv64
%define oblas_target RISCV64_GENERIC
%endif
%ifarch %mips
%define oblas_target MIPS32_GENERIC
%endif


Name: openblas
Version: 0.3.23
Release: alt1.2

Summary: Optimized BLAS library based on GotoBLAS2 1.13 
License: BSD
Group: Sciences/Mathematics
Url: https://github.com/xianyi/OpenBLAS
Vcs: https://github.com/xianyi/OpenBLAS
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires: gcc-fortran
%ifarch ppc64le
BuildRequires: libgomp-devel
%endif

%description
GotoBLAS2 has been released by the Texas Advanced Computing Center as
open source software under the BSD license. This product is no longer
under active development by TACC, but it is being made available to the
community to use, study, and extend. GotoBLAS2 uses new algorithms and
memory techniques for optimal performance of the BLAS routines. The
changes in this final version target new architecture features in
microprocessors and interprocessor communication techniques; also, NUMA
controls enhance multi-threaded execution of BLAS routines on node.

OpenBLAS is an optimized BLAS library based on GotoBLAS2 1.13 BSD
version. OpenBLAS is an open source project supported by Lab of Parallel
Software and Computational Science, ISCAS.

%package -n lib%name
Summary: Shared library of GotoBLAS2
Group: System/Libraries

%description -n lib%name
GotoBLAS2 has been released by the Texas Advanced Computing Center as
open source software under the BSD license. This product is no longer
under active development by TACC, but it is being made available to the
community to use, study, and extend. GotoBLAS2 uses new algorithms and
memory techniques for optimal performance of the BLAS routines. The
changes in this final version target new architecture features in
microprocessors and interprocessor communication techniques; also, NUMA
controls enhance multi-threaded execution of BLAS routines on node.

OpenBLAS is an optimized BLAS library based on GotoBLAS2 1.13 BSD
version. OpenBLAS is an open source project supported by Lab of Parallel
Software and Computational Science, ISCAS.

This package contains shared library of OpenBLAS.

%package -n lib%name-devel
Summary: Development files of GotoBLAS2
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
GotoBLAS2 has been released by the Texas Advanced Computing Center as
open source software under the BSD license. This product is no longer
under active development by TACC, but it is being made available to the
community to use, study, and extend. GotoBLAS2 uses new algorithms and
memory techniques for optimal performance of the BLAS routines. The
changes in this final version target new architecture features in
microprocessors and interprocessor communication techniques; also, NUMA
controls enhance multi-threaded execution of BLAS routines on node.

OpenBLAS is an optimized BLAS library based on GotoBLAS2 1.13 BSD
version. OpenBLAS is an open source project supported by Lab of Parallel
Software and Computational Science, ISCAS.

This package contains development files of OpenBLAS.

%prep
%setup
%autopatch -p1

%build
FLAGS="%optflags %optflags_shared"

# FC/CC - path to compiler
# F_COMPILER/C_COMPILER - compiler type (GCC, CLANG, GFORTRAN, etc.)
# COMMON_OPT - compiler options
FC="gfortran" F77="g77" CC="gcc" \
F_COMPILER="GFORTRAN" C_COMPILER="GCC" \
%make_build SMP=1 MAKE_NB_JOBS=${NPROCS:-%__nprocs} \
%if "%_lib" == "lib64"
	BINARY=64 \
	BINARY64=1 \
%else
	BINARY=32 \
%endif
%ifarch %ix86
	STATIC_ALLOCATION=1 \
%endif
	%{?oblas_target:TARGET=%oblas_target} \
	COMMON_OPT="$FLAGS" \
	%{?_enable_dynamic_arch:DYNAMIC_ARCH=1} \
	ALLOC_HUGETLB=1 \
	%{?_without_lapack:NO_LAPACK=1} \
	%{nil}

%install
%makeinstall_std \
    PREFIX=%_prefix \
    OPENBLAS_LIBRARY_DIR=%_libdir \
    OPENBLAS_INCLUDE_DIR=%_includedir/openblas \
    %{?oblas_target:TARGET=%oblas_target} \
    %nil

%check
%make_build tests \
	MAKE_NB_JOBS=${NPROCS:-%__nprocs} \
	%{?oblas_target:TARGET=%oblas_target} \
	%{?_enable_dynamic_arch:DYNAMIC_ARCH=1} \
	%{?_without_lapack:NO_LAPACK=1} \
	%{nil}

%files -n lib%name
%doc README* *.txt
%_libdir/*-r*.so
%_libdir/*.so.*

%files -n lib%name-devel
%exclude %_libdir/*-r*.so
%_libdir/*.so
%_pkgconfigdir/openblas.pc
%_includedir/openblas
%dir %_libdir/cmake/%name
%_libdir/cmake/%name/*.cmake
%exclude %_libdir/*.a

%changelog
