
%define rname OpenEXR
%define libsover 25
Name: openexr
Version: 2.5.6
Release: alt4

%define _cmake__builddir BUILD
%define common %name%libsover-common
%define libilmimf libilmimf%libsover
%define libilmimfutil libilmimfutil%libsover

Group: System/Libraries
Summary: A high-dynamic-range image file library
License: BSD-3-Clause
URL: http://www.openexr.org/

Requires: %libilmimf = %version-%release
Provides: %rname = %version-%release
Obsoletes: %rname < %version-%release
Provides: %name-utils = %version-%release
Obsoletes: %name-utils < %version-%release

Source: %name-%version.tar
# upstream
Patch1: oss-fuzz.patch
Patch2000: %name-e2k-simd.patch

BuildRequires: gcc-c++ glibc-devel ilmbase-devel zlib-devel
BuildRequires: cmake

%description
OpenEXR is an image file format and library developed by Industrial Light
& Magic, and later released to the public. It provides support for high
dynamic range and a 16-bit floating point "half" data type which is
compatible with the half data type in the Cg programming language.


%package -n %common
Group: System/Configuration/Other
Summary: Common empty package for %name
%description -n %common
Common empty package for %name

%package -n %libilmimf
Group: System/Libraries
Summary: libIlmImf %rname library
Requires: %common = %version-%release
Conflicts: openexr <= 1.6.1-alt1
%description -n %libilmimf
libIlmImf %rname library

%package -n %libilmimfutil
Group: System/Libraries
Summary: libIlmImfUtil %rname library
Requires: %common = %version-%release
Conflicts: openexr <= 1.6.1-alt1
%description -n %libilmimfutil
libIlmImfUtil %rname library

%package devel
Summary: Headers for developing programs that will use %rname
Group: Development/Other
Requires: %common = %version-%release
Requires: ilmbase-devel
#
%description devel
This package contains the static libraries and header files needed for
developing applications with %rname

%prep
%setup -q -n %name-%version
%patch1 -p1
%ifarch %e2k
%patch2000 -p2
%endif

%build
%cmake
%cmake_build

%install
make -C BUILD install DESTDIR=%buildroot


%files -n %common

%files
%_bindir/*

%files -n %libilmimf
%doc PATENTS README*
%_libdir/libIlmImf-*.so.%libsover
%_libdir/libIlmImf-*.so.%libsover.*
%files -n %libilmimfutil
%doc PATENTS README*
%_libdir/libIlmImfUtil-*.so.%libsover
%_libdir/libIlmImfUtil-*.so.%libsover.*

%files devel
%doc doc/*.pdf
%_includedir/%rname
%_libdir/lib*.so
%_libdir/pkgconfig/*
%_libdir/cmake/OpenEXR/
#%_datadir/aclocal/%name.m4


%changelog
