Name: openocd
Version: 0.11.0
Release: alt2

Summary: Debugging, in-system programming and boundary-scan testing for embedded devices
License: GPLv2
Group: Development/Tools
Url: http://sourceforge.net/projects/openocd

Source: %name-%version-%release.tar

BuildRequires: jimtcl-devel libftdi1-devel libgpiod-devel libhidapi-devel libjaylink-devel libusb-devel texinfo

%description
The Open On-Chip Debugger (OpenOCD) provides debugging, in-system
programming and boundary-scan testing for embedded devices. Various
different boards, targets, and interfaces are supported to ease
development time.

Install OpenOCD if you are looking for an open source solution for
hardware debugging.

%prep
%setup

%build
%autoreconf
%configure \
  --disable-werror \
  --disable-doxygen-html \
  --disable-internal-jimtcl \
  --disable-internal-libjaylink \
  --enable-aice \
  --enable-amtjtagaccel \
  --enable-at91rm9200 \
  --enable-bcm2835gpio \
  --enable-buspirate \
  --enable-cmsis-dap \
  --enable-dummy \
  --enable-ep93xx \
  --enable-ft2232_libftdi \
  --enable-ftdi \
  --enable-gw16012 \
  --enable-jlink \
  --enable-jtag_vpi \
  --enable-linuxgpiod \
  --enable-opendous \
  --enable-openjtag \
  --enable-osbdm \
  --enable-parport \
  --enable-parport_ppdev \
  --enable-presto \
  --enable-remote-bitbang \
  --enable-stlink \
  --enable-sysfsgpio \
  --enable-ti-icdi \
  --enable-ulink \
  --enable-usb-blaster \
  --enable-usb-blaster-2 \
  --enable-usb_blaster_libftdi \
  --enable-vsllink \
  CROSS=
%make_build

%install
%makeinstall_std
install -pm644 -D contrib/60-openocd.rules %buildroot%_udevrulesdir/60-openocd.rules

%pre
/usr/sbin/groupadd -r -f plugdev &>/dev/null ||:

%files
%doc AUTHORS BUGS ChangeLog HACKING NEWS* NEWTAPS
%doc README TODO
%doc %_datadir/%name/contrib/libdcc
%_udevrulesdir/*.rules
%_bindir/openocd
%_datadir/openocd
%exclude %_datadir/openocd/contrib
%_infodir/openocd.info*
%_mandir/man1/*

%changelog
