#%add_findreq_skiplist %_datadir/openstack-dashboard/openstack_dashboard/management/commands/horizon.wsgi.template
%define __find_provides cat > /dev/null
%define __find_requires cat > /dev/null
%define oname horizon
%def_with compression
%def_without tests

Name: openstack-dashboard
Version: 23.1.0
Release: alt1.p10
Epoch: 1
Summary: Openstack web user interface reference implementation

Group: System/Servers
# Code in horizon/horizon/utils taken from django which is BSD
License: ASL 2.0 and BSD
Url: http://docs.openstack.org/developer/%oname
Provides: openstack-dashboard-branding-upstream = %EVR
Provides: openstack-dashboard-theme = %EVR
Obsoletes: openstack-dashboard-theme < %EVR

Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz
Source1: openstack-dashboard-httpd.conf
Source11: openstack-dashboard-httpd-ssl.conf

# systemd snippet to collect static files and compress on httpd restart
Source3:    python-django-horizon-systemd.conf

# demo config for separate logging
Source4: openstack-dashboard-httpd-logging.conf

# logrotate config
Source5:    python-django-horizon-logrotate.conf

BuildArch: noarch

Provides: openstack-dashboard-branding-upstream = %EVR
Provides: openstack-dashboard-theme = %EVR
Obsoletes: openstack-dashboard-theme < %EVR

BuildRequires(pre): webserver-common rpm-build-webserver-common rpm-macros-apache2
BuildRequires: gettext-tools
BuildRequires: python3-devel git-core
BuildRequires: python3-module-wheel
BuildRequires: python3-module-memcached
BuildRequires: python3-module-django-dbbackend-sqlite3

BuildRequires: python3-module-pbr >= 5.5.0
BuildRequires: python3-module-babel >= 2.6.0
BuildRequires: python3-module-django >= 3.2 python3-module-django < 3.3
BuildRequires: python3-module-django-compressor >= 2.4.1
BuildRequires: python3-module-django-debreach >= 1.4.2
BuildRequires: python3-module-django-pyscss >= 2.0.2
BuildRequires: python3-module-futurist >= 1.2.0
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-keystoneauth1 >= 4.3.1
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-oslo.concurrency >= 4.5.0
BuildRequires: python3-module-oslo.config >= 8.8.0
BuildRequires: python3-module-oslo.i18n >= 5.1.0
BuildRequires: python3-module-oslo.policy >= 3.11.0
BuildRequires: python3-module-oslo.serialization >= 4.3.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.5.0
BuildRequires: python3-module-oslo.utils >= 4.12.0
BuildRequires: python3-module-osprofiler >= 3.4.2
BuildRequires: python3-module-pymongo >= 3.0.2
BuildRequires: python3-module-pyScss >= 1.4.0
BuildRequires: python3-module-cinderclient >= 8.0.0
BuildRequires: python3-module-glanceclient >= 2.8.0
BuildRequires: python3-module-keystoneclient >= 3.22.0
BuildRequires: python3-module-neutronclient >= 8.1.0
BuildRequires: python3-module-novaclient >= 9.1.0
BuildRequires: python3-module-swiftclient >= 3.2.0
BuildRequires: python3-module-pytz >= 2013.6
BuildRequires: python3-module-yaml >= 6.0
BuildRequires: python3-module-requests >= 2.25.1
BuildRequires: python3-module-six >= 1.16.0
BuildRequires: python3-module-semantic_version >= 2.3.1
BuildRequires: python3-module-xstatic >= 1.0.0
BuildRequires: python3-module-xstatic-angular >= 1.8.2.2
BuildRequires: python3-module-xstatic-angular-bootstrap >= 2.2.0.0
BuildRequires: python3-module-xstatic-angular-fileupload >= 12.0.4.0
BuildRequires: python3-module-xstatic-angular-gettext >= 2.3.8.0
BuildRequires: python3-module-xstatic-angular-lrdragndrop >= 1.0.2.2
BuildRequires: python3-module-xstatic-angular-schema-form >= 0.8.13.0
BuildRequires: python3-module-xstatic-bootstrap-datepicker >= 1.3.1.0
BuildRequires: python3-module-xstatic-bootstrap-scss >= 3.3.7.1
BuildRequires: python3-module-xstatic-bootswatch >= 3.3.7.0
BuildRequires: python3-module-xstatic-d3 >= 3.5.17.0
BuildRequires: python3-module-xstatic-hogan >= 2.0.0.2
BuildRequires: python3-module-xstatic-font-awesome >= 4.7.0.0
BuildRequires: python3-module-xstatic-jasmine >= 2.4.1.1
BuildRequires: python3-module-xstatic-jquery >= 1.12.4.1 python3-module-xstatic-jquery < 2
BuildRequires: python3-module-xstatic-jquery-migrate >= 1.2.1.1
BuildRequires: python3-module-xstatic-jquery.quicksearch >= 2.0.3.1
BuildRequires: python3-module-xstatic-jquery.tablesorter >= 2.14.5.1
BuildRequires: python3-module-xstatic-jquery-ui >= 1.12.1.1
BuildRequires: python3-module-xstatic-jsencrypt >= 2.3.1.1
BuildRequires: python3-module-xstatic-mdi >= 1.6.50.2
BuildRequires: python3-module-xstatic-objectpath >= 1.2.1.0
BuildRequires: python3-module-xstatic-rickshaw >= 1.5.0.0
BuildRequires: python3-module-xstatic-roboto-fontface >= 0.5.0.0
BuildRequires: python3-module-xstatic-smart-table >= 1.4.13.2
BuildRequires: python3-module-xstatic-spin >= 1.2.5.2
BuildRequires: python3-module-xstatic-term.js >= 0.0.7.0
BuildRequires: python3-module-xstatic-tv4 >= 1.2.7.0
BuildRequires: python3-module-enmerkar >= 0.7.1

%if_with tests
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-freezegun >= 0.3.15
BuildRequires: python3-module-nodeenv >= 0.9.4
BuildRequires: python3-module-pytest >= 5.3.5
BuildRequires: python3-module-pytest-django >= 3.8.0
BuildRequires: python3-module-pytest-html >= 2.0.1
BuildRequires: python3-module-memcached >= 1.59
BuildRequires: python3-module-selenium >= 2.50.1
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-xvfbwrapper >= 0.1.3
%endif

# doc
BuildRequires: python3-module-openstackdocstheme >= 2.2.0
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-doc8 >= 0.8.1
BuildRequires: python3-module-mock >= 2.0.0
BuildRequires: python3-module-pytest >= 5.3.5

Requires: apache2-base
Requires: apache2-mod_wsgi-py3
Requires: python3-module-django-horizon = %EVR
Requires: python3-module-django-openstack-auth  = %EVR
Requires: openssl
Requires: logrotate

%description
Horizon is a Django-based project aimed at providing a complete OpenStack
Dashboard along with an extensible framework for building new dashboards
from reusable components. The openstack_dashboard module is a reference
implementation of a Django site that uses the horizon app to provide
web-based interactions with the various OpenStack projects.

%package -n python3-module-django-%oname
Summary: Django application for talking to Openstack
Group: Development/Python3

#%py3_provides openstack_dashboard
#%py3_provides openstack_dashboard.utils

Requires: python3-module-pbr >= 5.5.0
Requires: python3-module-babel >= 2.6.0
Requires: python3-module-django >= 3.2 python3-module-django < 3.3
Requires: python3-module-django-compressor >= 2.4.1
Requires: python3-module-django-debreach >= 1.4.2
Requires: python3-module-django-pyscss >= 2.0.2
Requires: python3-module-futurist >= 1.2.0
Requires: python3-module-iso8601 >= 0.1.11
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-netaddr >= 0.7.18
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-osprofiler >= 3.4.2
Requires: python3-module-pymongo >= 3.0.2
Requires: python3-module-pyScss >= 1.4.0
Requires: python3-module-cinderclient >= 9.2.0 python3-module-cinderclient <= 9.3.0
Requires: python3-module-glanceclient >= 4.2.0 python3-module-glanceclient <= 4.3.0
Requires: python3-module-keystoneclient = 5.1.0
Requires: python3-module-neutronclient >= 8.2.0 python3-module-neutronclient <= 9.0.0
Requires: python3-module-novaclient >= 18.2.0 python3-module-novaclient <= 18.3.0
Requires: python3-module-swiftclient = 4.2.0
Requires: python3-module-pytz >= 2013.6
Requires: python3-module-yaml >= 6.0
Requires: python3-module-requests >= 2.25.1
Requires: python3-module-six >= 1.16.0
Requires: python3-module-semantic_version >= 2.3.1
Requires: python3-module-xstatic >= 1.0.0
Requires: python3-module-xstatic-angular >= 1.8.2.2
Requires: python3-module-xstatic-angular-bootstrap >= 2.2.0.0
Requires: python3-module-xstatic-angular-fileupload >= 12.0.4.0
Requires: python3-module-xstatic-angular-gettext >= 2.3.8.0
Requires: python3-module-xstatic-angular-lrdragndrop >= 1.0.2.2
Requires: python3-module-xstatic-angular-schema-form >= 0.8.13.0
Requires: python3-module-xstatic-bootstrap-datepicker >= 1.3.1.0
Requires: python3-module-xstatic-bootstrap-scss >= 3.3.7.1
Requires: python3-module-xstatic-bootswatch >= 3.3.7.0
Requires: python3-module-xstatic-d3 >= 3.5.17.0
Requires: python3-module-xstatic-hogan >= 2.0.0.2
Requires: python3-module-xstatic-font-awesome >= 4.7.0.0
Requires: python3-module-xstatic-jasmine >= 2.4.1.1
Requires: python3-module-xstatic-jquery >= 1.12.4.1
Requires: python3-module-xstatic-jquery-migrate >= 1.2.1.1
Requires: python3-module-xstatic-jquery.quicksearch >= 2.0.3.1
Requires: python3-module-xstatic-jquery.tablesorter >= 2.14.5.1
Requires: python3-module-xstatic-jquery-ui >= 1.12.1.1
Requires: python3-module-xstatic-jsencrypt >= 2.3.1.1
Requires: python3-module-xstatic-mdi >= 1.6.50.2
Requires: python3-module-xstatic-objectpath >= 1.2.1.0
Requires: python3-module-xstatic-rickshaw >= 1.5.0.0
Requires: python3-module-xstatic-roboto-fontface >= 0.5.0.0
Requires: python3-module-xstatic-smart-table >= 1.4.13.2
Requires: python3-module-xstatic-spin >= 1.2.5.2
Requires: python3-module-xstatic-term.js >= 0.0.7.0
Requires: python3-module-xstatic-tv4 >= 1.2.7.0
Requires: python3-module-enmerkar >= 0.7.1

%description -n python3-module-django-%oname
Horizon is a Django application for providing Openstack UI components.
It allows performing site administrator (viewing account resource usage,
configuring users, accounts, quotas, flavors, etc.) and end user
operations (start/stop/delete instances, create/restore snapshots, view
instance VNC console, etc.)

%if_with tests
%package -n python3-module-django-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
AutoReq: yes, nopython

%description -n python3-module-django-%oname-tests
This package contains tests for %oname.
%endif

%package -n python3-module-django-openstack-auth
Summary: Django authentication backend for OpenStack Keystone
Group: Development/Python3

%description -n python3-module-django-openstack-auth
Django OpenStack Auth is a pluggable Django authentication backend that
works with Django's contrib.auth framework to authenticate a user against
OpenStack's Keystone Identity API.

%package -n python3-module-django-openstack-auth-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-django-openstack-auth = %EVR

%description -n python3-module-django-openstack-auth-tests
This package contains tests for %oname.

%package doc
Summary: Documentation for Django Horizon
Group: Development/Documentation

%description doc
Documentation for the Django Horizon application for talking with Openstack

%prep
%setup -n %oname-%version

git init-db
git config user.email "real at altlinux.org"
git config user.name "REAL"
git add . -A
git commit -a -m "commit"
git tag %version

# remove unnecessary .mo files
# they will be generated later during package build
find . -name "django*.mo" -exec rm -fv '{}' \;

# drop config snippet
cp -p %SOURCE4 .

sed -i "/^DEBUG =.*/c\DEBUG = False" openstack_dashboard/local/local_settings.py.example
sed -i "/^WEBROOT =.*/c\WEBROOT = '/dashboard/'" openstack_dashboard/local/local_settings.py.example
sed -i "/^.*ALLOWED_HOSTS =.*/c\ALLOWED_HOSTS = ['horizon.example.com', 'localhost']" openstack_dashboard/local/local_settings.py.example
sed -i "/^.*LOCAL_PATH =.*/c\LOCAL_PATH = '/tmp'" openstack_dashboard/local/local_settings.py.example
sed -i "/^.*POLICY_FILES_PATH =.*/c\POLICY_FILES_PATH = '/etc/openstack-dashboard'" openstack_dashboard/local/local_settings.py.example

sed -i "/^BIN_DIR = .*/c\BIN_DIR = '/usr/bin'" openstack_dashboard/settings.py
sed -i "/^COMPRESS_PARSER = .*/a COMPRESS_OFFLINE = True" openstack_dashboard/settings.py

%if_with compression
# set COMPRESS_OFFLINE=True
sed -i 's:COMPRESS_OFFLINE.=.False:COMPRESS_OFFLINE = True:' openstack_dashboard/settings.py
%else
# set COMPRESS_OFFLINE=False
sed -i 's:COMPRESS_OFFLINE = True:COMPRESS_OFFLINE = False:' openstack_dashboard/settings.py
%endif

#rm -rf ../python3
#cp -a . ../python3

%build

# compile message strings
cd horizon && django-admin compilemessages && cd ..
cd openstack_dashboard && django-admin compilemessages && cd ..
# Dist tarball is missing .mo files so they're not listed in distributed egg metadata.
# Removing egg-info and letting PBR regenerate it was working around that issue
# but PBR cannot regenerate complete SOURCES.txt so some other files wont't get installed.
# Further reading why not remove upstream egg metadata:
# https://github.com/emonty/python-oslo-messaging/commit/f632684eb2d582253601e8da7ffdb8e55396e924
# https://fedorahosted.org/fpc/ticket/488
#echo >> horizon.egg-info/SOURCES.txt
#ls */locale/*/LC_MESSAGES/django*mo >> horizon.egg-info/SOURCES.txt

%pyproject_build

# compress css, js etc.
cp openstack_dashboard/local/local_settings.py.example openstack_dashboard/local/local_settings.py
# get it ready for compressing later in puppet-horizon
%if_with compression
python3 manage.py collectstatic --noinput --clear
python3 manage.py compress --force
%endif

# build docs
sphinx-build -b html doc/source html

# undo hack
cp openstack_dashboard/local/local_settings.py.example openstack_dashboard/local/local_settings.py

# Fix hidden-file-or-dir warnings
rm -fr html/.doctrees html/.buildinfo

%install
%pyproject_install

# drop httpd-conf snippet
install -m 0644 -D -p %SOURCE1 %buildroot%apache2_sites_available/openstack-dashboard.conf
install -m 0644 -D -p %SOURCE11 %buildroot%apache2_sites_available/openstack-dashboard-ssl.conf
mkdir -p %buildroot%apache2_sites_enabled
touch %buildroot%apache2_sites_enabled/openstack-dashboard.conf
touch %buildroot%apache2_sites_available/openstack-dashboard-ssl.conf

install -d -m 755 %buildroot%_datadir/openstack-dashboard
install -d -m 755 %buildroot%_sharedstatedir/openstack-dashboard
install -d -m 755 %buildroot%_sharedstatedir/openstack-dashboard/static
install -d -m 750 %buildroot%_sharedstatedir/openstack-dashboard/secret-key
install -d -m 755 %buildroot%_sysconfdir/openstack-dashboard

# create directory for systemd snippet
mkdir -p %buildroot%_unitdir/httpd2.service.d/
cp %SOURCE3 %buildroot%_unitdir/httpd2.service.d/openstack-dashboard.conf

# Copy everything to /usr/share
mv %buildroot%python3_sitelibdir/openstack_dashboard \
   %buildroot%_datadir/openstack-dashboard
cp manage.py %buildroot%_datadir/openstack-dashboard
rm -rf %buildroot%python3_sitelibdir/openstack_dashboard
rm -rf %buildroot%python3_sitelibdir/openstack_dashboard
#find %buildroot%_datadir/openstack-dashboard -name *.pyc -exec rm '{}' \;

# remove unnecessary .po files
find %buildroot -name django.po -exec rm '{}' \;
find %buildroot -name djangojs.po -exec rm '{}' \;

# Move config to /etc, symlink it back to /usr/share
mv %buildroot%_datadir/openstack-dashboard/openstack_dashboard/local/local_settings.py.example %buildroot%_sysconfdir/openstack-dashboard/local_settings
ln -s ../../../../../%_sysconfdir/openstack-dashboard/local_settings %buildroot%_datadir/openstack-dashboard/openstack_dashboard/local/local_settings.py

mv %buildroot%_datadir/openstack-dashboard/openstack_dashboard/conf/*.yaml %buildroot%_sysconfdir/openstack-dashboard/
mv %buildroot%_datadir/openstack-dashboard/openstack_dashboard/conf/default_policies %buildroot%_sysconfdir/openstack-dashboard
mv %buildroot%_datadir/openstack-dashboard/openstack_dashboard/conf/nova_policy.d %buildroot%_sysconfdir/openstack-dashboard

%find_lang django --all-name

grep "\/usr\/share\/openstack-dashboard" django.lang > dashboard.lang
grep "\/site-packages\/horizon" django.lang > horizon.lang

# copy static files to %_datadir/openstack-dashboard/static
mkdir -p %buildroot%_datadir/openstack-dashboard/static
cp -a openstack_dashboard/static/* %buildroot%_datadir/openstack-dashboard/static
cp -a horizon/static/* %buildroot%_datadir/openstack-dashboard/static
cp -a static/* %buildroot%_datadir/openstack-dashboard/static
cp -a openstack_dashboard/themes %buildroot%_datadir/openstack-dashboard/openstack_dashboard/
# ln -r -s %buildroot%_datadir/openstack-dashboard/static/themes %buildroot%_datadir/openstack-dashboard/openstack_dashboard/static/themes

# create /var/run/openstack-dashboard/ and own it
mkdir -p %buildroot%_runtimedir/openstack-dashboard

# create /var/log/horizon and own it
mkdir -p %buildroot%_logdir/horizon

# place logrotate config:
mkdir -p %buildroot%_sysconfdir/logrotate.d
cp -a %SOURCE5 %buildroot%_sysconfdir/logrotate.d/openstack-dashboard

#%%check
#%%__python3 manage.py test horizon --settings=horizon.test.settings --ignore-files="(test_checks|firefox_binary|webdriver|pull_catalog)"

%pre
%_sbindir/groupadd -r -f dashboard 2>/dev/null ||:
%_sbindir/useradd -r -g dashboard -G _webserver -c 'OpenStack Dashboard Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/openstack-dashboard dashboard 2>/dev/null ||:

%post
# ugly hack to set a unique SECRET_KEY
sed -i "/^from horizon.utils import secret_key$/d" /etc/openstack-dashboard/local_settings
sed -i "/^SECRET_KEY.*$/{N;s/^.*$/SECRET_KEY='`openssl rand -hex 10`'/}" /etc/openstack-dashboard/local_settings
# reload systemd unit files
systemctl daemon-reload >/dev/null 2>&1 || :

%files -n python3-module-django-%oname
%python3_sitelibdir/horizon
%python3_sitelibdir/horizon-%version.dist-info
%exclude %python3_sitelibdir/horizon/test/__pycache__/
%exclude %python3_sitelibdir/horizon/test/customization/
%exclude %python3_sitelibdir/horizon/test/dummy_auth/
%exclude %python3_sitelibdir/horizon/test/firefox_binary.py
%exclude %python3_sitelibdir/horizon/test/helpers.py
%exclude %python3_sitelibdir/horizon/test/messages/
%exclude %python3_sitelibdir/horizon/test/selenium/
%exclude %python3_sitelibdir/horizon/test/settings.py
%exclude %python3_sitelibdir/horizon/test/templates/
%exclude %python3_sitelibdir/horizon/test/test_dashboards/
%exclude %python3_sitelibdir/horizon/test/unit/
%exclude %python3_sitelibdir/horizon/test/urls.py
%exclude %python3_sitelibdir/horizon/test/utils.py
%exclude %python3_sitelibdir/horizon/test/webdriver.py

%if_with tests
%files -n python3-module-django-%oname-tests
%python3_sitelibdir/horizon/test
%exclude %python3_sitelibdir/horizon/test/__init__.py
%exclude %python3_sitelibdir/horizon/test/jasmine/
%_datadir/openstack-dashboard/openstack_dashboard/karma.conf.js
%_datadir/openstack-dashboard/openstack_dashboard/test
%endif

%files -n python3-module-django-openstack-auth
%python3_sitelibdir/openstack_auth
%exclude %python3_sitelibdir/openstack_auth/tests

%if_with tests
%files -n python3-module-django-openstack-auth-tests
%python3_sitelibdir/openstack_auth/tests
%endif

%files
%doc LICENSE README.rst openstack-dashboard-httpd-logging.conf
%attr(0755, root, _webserver) %_datadir/openstack-dashboard
%exclude %_datadir/openstack-dashboard/openstack_dashboard/test
%exclude %_datadir/openstack-dashboard/openstack_dashboard/karma.conf.js

%dir %attr(0750, root, _webserver) %_sysconfdir/openstack-dashboard
%dir %attr(0750, root, _webserver) %_sysconfdir/openstack-dashboard/default_policies/
%dir %attr(0750, root, _webserver) %_sysconfdir/openstack-dashboard/nova_policy.d/
%dir %attr(0770, root, _webserver) %_sharedstatedir/openstack-dashboard
%dir %attr(0755, root, _webserver) %_sharedstatedir/openstack-dashboard/static
%dir %attr(0750, root, _webserver) %_sharedstatedir/openstack-dashboard/secret-key
%dir %attr(0770, root, _webserver) %_sharedstatedir/openstack-dashboard
%config(noreplace) %apache2_sites_available/*.conf
%ghost %apache2_sites_enabled/*.conf
%config(noreplace) %attr(0640, root, _webserver) %_sysconfdir/openstack-dashboard/local_settings
%config(noreplace) %attr(0640, root, _webserver) %_sysconfdir/openstack-dashboard/*.yaml
%config(noreplace) %attr(0640, root, _webserver) %_sysconfdir/openstack-dashboard/nova_policy.d/api-extensions.yaml
%config(noreplace) %attr(0640, root, _webserver) %_sysconfdir/openstack-dashboard/default_policies/*.yaml
%config(noreplace) %attr(0644, root, root) %_sysconfdir/logrotate.d/openstack-dashboard
%config(noreplace) %_unitdir/httpd2.service.d/openstack-dashboard.conf

%files doc
%doc html

%changelog
