%define oname glance
%def_without docs

Name: openstack-%oname
Epoch: 1
Version: 26.0.0
Release: alt1.p10

Summary: OpenStack Image Service

Group: System/Servers
License: ASL 2.0
Url: http://docs.openstack.org/developer/%oname

Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz
Source1: %name-api.service
Source3: %name-scrubber.service
Source4: %name.logrotate

Source40: %name-api.init
Source42: %name-scrubber.init
Source43: %name.tmpfiles

BuildArch: noarch

Requires(pre): shadow-utils
Requires: python3-module-glance = %EVR
Requires: python3-module-glanceclient >= 4.2.0 python3-module-glanceclient <= 4.3.0
Requires: /usr/bin/qemu-img

BuildRequires: crudini

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 3.1.1
BuildRequires: python3-module-defusedxml >= 0.6.0
BuildRequires: python3-module-sqlalchemy >= 1.3.14
BuildRequires: python3-module-eventlet >= 0.25.1
BuildRequires: python3-module-PasteDeploy >= 1.5.0
BuildRequires: python3-module-routes >= 2.3.1
BuildRequires: python3-module-webob >= 1.8.0
BuildRequires: python3-module-sqlparse >= 0.2.2
BuildRequires: python3-module-alembic >= 0.9.6
BuildRequires: python3-module-httplib2 >= 0.9.1
BuildRequires: python3-module-oslo.config >= 8.1.0
BuildRequires: python3-module-oslo.concurrency >= 4.5.1
BuildRequires: python3-module-oslo.context >= 2.22.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.3.0
BuildRequires: python3-module-oslo.utils >= 4.7.0
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-futurist >= 1.2.0
BuildRequires: python3-module-taskflow >= 4.0.0
BuildRequires: python3-module-keystoneauth1 >= 3.4.0
BuildRequires: python3-module-keystonemiddleware >= 5.1.0
BuildRequires: python3-module-wsme >= 0.8.0
BuildRequires: python3-module-prettytable >= 0.7.1
BuildRequires: python3-module-paste >= 2.0.2
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-openssl >= 17.1.0
BuildRequires: python3-module-oslo.db >= 5.0.0
BuildRequires: python3-module-oslo.i18n >= 5.0.0
BuildRequires: python3-module-oslo.limit >= 1.6.0
BuildRequires: python3-module-oslo.log >= 4.5.0
BuildRequires: python3-module-oslo.messaging >= 5.29.0
BuildRequires: python3-module-oslo.middleware >= 3.31.0
BuildRequires: python3-module-oslo.reports >= 1.18.0
BuildRequires: python3-module-oslo.policy >= 3.11.0
BuildRequires: python3-module-retrying >= 1.2.3
BuildRequires: python3-module-osprofiler >= 1.4.0
BuildRequires: python3-module-glance_store >= 2.3.0
BuildRequires: python3-module-debtcollector >= 1.19.0
BuildRequires: python3-module-cryptography >= 2.6.1
BuildRequires: python3-module-cursive >= 0.2.1
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-os-win >= 4.0.1
BuildRequires: python3-module-castellan >= 0.17.0

%if_with docs
# Required to build module documents
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-os-api-ref >= 1.4.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-sphinxcontrib-apidoc >= 0.2.0
BuildRequires: python3-module-whereto >= 0.3.0
BuildRequires: python3-module-xattr >= 0.9.2
%endif

%description
OpenStack Image Service (code-named Glance) provides discovery, registration,
and delivery services for virtual disk images. The Image Service API server
provides a standard REST interface for querying information about virtual disk
images stored in a variety of back-end stores, including OpenStack Object
Storage. Clients can register new virtual disk images with the Image Service,
query for information on publicly available disk images, and use the Image
Service's client library for streaming virtual disk images.

This package contains the API and registry servers.

%package -n python3-module-%oname
Summary: Glance Python libraries
Group: Development/Python3

AutoReqProv: no

Requires: python3-module-pbr >= 3.1.1
Requires: python3-module-defusedxml >= 0.6.0
Requires: python3-module-sqlalchemy >= 1.3.14
Requires: python3-module-eventlet >= 0.33.3
Requires: python3-module-PasteDeploy >= 1.5.0
Requires: python3-module-routes >= 2.3.1
Requires: python3-module-webob >= 1.8.0
Requires: python3-module-sqlparse >= 0.2.2
Requires: python3-module-alembic >= 0.9.6
Requires: python3-module-httplib2 >= 0.9.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-futurist >= 1.2.0
Requires: python3-module-taskflow = 5.1.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-keystonemiddleware = 10.2.0
Requires: python3-module-wsme >= 0.8.0
Requires: python3-module-prettytable >= 0.7.1
Requires: python3-module-paste >= 2.0.2
Requires: python3-module-jsonschema >= 3.2.0
Requires: python3-module-openssl >= 17.1.0
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.limit = 2.1.0
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.messaging >= 14.1.0 python3-module-oslo.messaging <= 14.2.2
Requires: python3-module-oslo.middleware >= 5.1.0 python3-module-oslo.middleware <= 5.1.1
Requires: python3-module-oslo.reports = 3.0.0
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-retrying >= 1.2.3
Requires: python3-module-osprofiler >= 1.4.0
Requires: python3-module-glance_store >= 4.2.0 python3-module-glance_store <= 4.3.1
Requires: python3-module-debtcollector >= 1.19.0
Requires: python3-module-cryptography >= 2.6.1
Requires: python3-module-cursive >= 0.2.1
Requires: python3-module-iso8601 >= 0.1.11
Requires: python3-module-os-win >= 5.8.0 python3-module-os-win <= 5.9.0
Requires: python3-module-castellan = 4.1.0

%add_python3_req_skip glance.cmd.cache_manage

%description -n python3-module-%oname
OpenStack Image Service (code-named Glance) provides discovery, registration,
and delivery services for virtual disk images.

This package contains the glance Python library.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3

%description -n python3-module-%oname-tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for OpenStack Image Service
Group: Development/Documentation
Requires: %name = %EVR

%description doc
OpenStack Image Service (code-named Glance) provides discovery, registration,
and delivery services for virtual disk images.

This package contains documentation files for glance.
%endif

%prep
%setup -n %oname-%version

# Remove the requirements file so that pbr hooks don't add it
# to distutils requiers_dist config
rm -rf {test-,}requirements.txt tools/{pip,test}-requires

%build
export PBR_VERSION=%version
%pyproject_build

#python3 setup.py build_sphinx
#python3 setup.py build_sphinx -b man
# Fix hidden-file-or-dir warnings
#rm -fr build/sphinx/html/.buildinfo
# regenerate the sample config files
#for service in api registry scrubber cache manage glare; do
#    PYTHONPATH=. oslo-config-generator --config-file etc/oslo-config-generator/glance-$service.conf
#done

%install
%pyproject_install

install -d -m 0755 %buildroot%_sysconfdir/glance
install -d -m 0755 %buildroot%_sysconfdir/glance/metadefs

### configuration files
install -d -m 755 %buildroot%_sysconfdir/glance
install -d -m 755 %buildroot%_sysconfdir/glance/glance.conf.d/

cp -pr etc/* %buildroot%_sysconfdir/glance

cp glance/db/sqlalchemy/alembic_migrations/alembic.ini %buildroot%python3_sitelibdir/glance/db/sqlalchemy/alembic_migrations/

#for service in api registry scrubber cache manage glare swift; do
#for service in image-import swift; do
#    mv %buildroot%_sysconfdir/glance/glance-$service.conf{.sample,}
#done

# documentation
#install -d %buildroot%_mandir/man1
#install -m 644 doc/build/man/*.1 %buildroot%_mandir/man1

rm -rf %buildroot%_sysconfdir/glance/oslo-config-generator

install -d -m 755 %buildroot%_sharedstatedir/glance/images
install -d -m 755 %buildroot%_sharedstatedir/glance/image-cache
install -d -m 755 %buildroot%_sharedstatedir/glance/image-cache/incomplete
install -d -m 755 %buildroot%_sharedstatedir/glance/image-cache/invalid
install -d -m 755 %buildroot%_sharedstatedir/glance/image-cache/queue

# Initscripts
install -p -D -m 644 %SOURCE1 %buildroot%_unitdir/openstack-glance-api.service
install -p -D -m 644 %SOURCE3 %buildroot%_unitdir/openstack-glance-scrubber.service

# Initscripts
install -p -D -m 755 %SOURCE40 %buildroot%_initdir/openstack-glance-api
install -p -D -m 755 %SOURCE42 %buildroot%_initdir/openstack-glance-scrubber

install -p -D -m 644 %SOURCE43 %buildroot%_tmpfilesdir/%name.conf

# Logrotate config
install -p -D -m 644 %SOURCE4 %buildroot%_sysconfdir/logrotate.d/openstack-glance

# Install pid directory
install -d -m 755 %buildroot%_runtimedir/glance

# Install log directory
install -d -m 770 %buildroot%_logdir/glance

# Delete unneeded files
rm -rf %buildroot/usr/etc

### set default configuration
%define glance_conf %buildroot%_sysconfdir/glance/glance.conf.d/010-glance.conf
crudini --set %glance_conf DEFAULT log_dir /var/log/glance
crudini --set %glance_conf oslo_concurrency lock_path /var/run/glance
crudini --set %glance_conf paste_deploy flavor keystone

%pre
# 161:161 for glance (openstack-glance)
%_sbindir/groupadd -r -g 161 -f glance 2>/dev/null ||:
%_sbindir/useradd -r -u 161 -g glance -c 'OpenStack Glance Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/glance glance 2>/dev/null ||:

%post
%post_service %name-api
%post_service %name-scrubber

%preun
%preun_service %name-api
%preun_service %name-scrubber

%files
%doc README.rst
%_unitdir/*
%_initdir/*
%_tmpfilesdir/*

#%%_man1dir/*
%dir %_sysconfdir/glance
%dir %_sysconfdir/glance/glance.conf.d
%config(noreplace) %attr(640, root, glance) %_sysconfdir/glance/*.conf
%config(noreplace) %attr(640, root, glance) %_sysconfdir/glance/glance.conf.d/010-glance.conf
%config %_sysconfdir/glance/*.ini
%config %_sysconfdir/glance/*.json
%config %_sysconfdir/glance/*.sample
%dir %_sysconfdir/glance/metadefs
%_sysconfdir/glance/metadefs/README
%config %_sysconfdir/glance/metadefs/*.json
%config(noreplace) %_sysconfdir/logrotate.d/%name
%dir %attr(0775, root, glance) %_sharedstatedir/glance
%dir %attr(0775, root, glance) %_sharedstatedir/glance/image-cache
%dir %attr(0775, root, glance) %_sharedstatedir/glance/image-cache/incomplete
%dir %attr(0775, root, glance) %_sharedstatedir/glance/image-cache/invalid
%dir %attr(0775, root, glance) %_sharedstatedir/glance/image-cache/queue
%dir %attr(0775, root, glance) %_sharedstatedir/glance/images
%dir %attr(0770, root, glance) %_logdir/glance
%dir %attr(0775, root, glance) %_runtimedir/glance

%files -n python3-module-%oname
%doc README.rst
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests

#%files doc
#%doc doc/build/html

%changelog
