%define oname nova

%def_without doc
%def_without tests

Name: openstack-%oname
Epoch: 1
Version: 27.1.0
Release: alt1.p10

Summary: OpenStack Compute (nova)

Group: System/Servers
License: ASL 2.0
Url: https://github.com/openstack/nova

Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz

Source6: nova.logrotate

Source3: %name.tmpfiles

Source10: %name-api.service
Source12: %name-compute.service
Source15: %name-scheduler.service
Source25: %name-metadata-api.service
Source26: %name-conductor.service
Source28: %name-spicehtml5proxy.service
Source29: %name-novncproxy.service
Source31: %name-serialproxy.service
Source32: %name-api-os-compute.service

Source110: %name-api.init
Source112: %name-compute.init
Source115: %name-scheduler.init
Source125: %name-metadata-api.init
Source126: %name-conductor.init
Source128: %name-spicehtml5proxy.init
Source129: %name-novncproxy.init
Source131: %name-serialproxy.init
Source132: %name-api-os-compute.init

Source21: nova-polkit.pkla
Source23: nova-polkit.rules
Source22: nova-ifc-template
Source24: nova-sudoers
Source30: %name-novncproxy.sysconfig

BuildArch: noarch

# /proc need for generate sample config fix "nova.cmd.novncproxy: [Errno 2] No such file or directory: '/proc/stat'"
BuildRequires: /proc
BuildRequires: crudini
BuildRequires: graphviz

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 5.8.0
BuildRequires: python3-module-sqlalchemy >= 1.4.13
BuildRequires: python3-module-decorator >= 4.1.0
BuildRequires: python3-module-eventlet >= 0.30.1
BuildRequires: python3-module-jinja2 >= 2.10
BuildRequires: python3-module-keystonemiddleware >= 4.20.0
BuildRequires: python3-module-lxml >= 4.5.0
BuildRequires: python3-module-routes >= 2.3.1
BuildRequires: python3-module-cryptography >= 2.7
BuildRequires: python3-module-webob >= 1.8.2
BuildRequires: python3-module-greenlet >= 0.4.15
BuildRequires: python3-module-PasteDeploy >= 1.5.0
BuildRequires: python3-module-paste >= 2.0.2
BuildRequires: python3-module-prettytable >= 0.7.1
BuildRequires: python3-module-migrate >= 0.13.0
BuildRequires: python3-module-alembic >= 1.5.0
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-netifaces >= 0.10.4
BuildRequires: python3-module-paramiko >= 2.7.1
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-cinderclient >= 3.3.0
BuildRequires: python3-module-keystoneauth1 >= 3.16.0
BuildRequires: python3-module-neutronclient >= 7.1.0
BuildRequires: python3-module-glanceclient >= 2.8.0
BuildRequires: python3-module-requests >= 2.25.1
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-websockify >= 0.9.0
BuildRequires: python3-module-oslo.cache >= 1.26.0
BuildRequires: python3-module-oslo.concurrency >= 5.0.1
BuildRequires: python3-module-oslo.config >= 8.6.0
BuildRequires: python3-module-oslo.context >= 3.4.0
BuildRequires: python3-module-oslo.log >= 4.6.1
BuildRequires: python3-module-oslo.limit >= 1.5.0
BuildRequires: python3-module-oslo.reports >= 1.18.0
BuildRequires: python3-module-oslo.serialization >= 4.2.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.3.0
BuildRequires: python3-module-oslo.utils >= 4.12.1
BuildRequires: python3-module-oslo.db >= 10.0.0
BuildRequires: python3-module-oslo.rootwrap >= 5.15.0
BuildRequires: python3-module-oslo.messaging >= 14.1.0
BuildRequires: python3-module-oslo.policy >= 3.11.0
BuildRequires: python3-module-oslo.privsep >= 2.6.2
BuildRequires: python3-module-oslo.i18n >= 5.1.0
BuildRequires: python3-module-oslo.service >= 2.8.0
BuildRequires: python3-module-rfc3986 >= 1.2.0
BuildRequires: python3-module-oslo.middleware >= 3.31.0
BuildRequires: python3-module-psutil >= 3.2.2
BuildRequires: python3-module-oslo.versionedobjects >= 1.35.0
BuildRequires: python3-module-os-brick >= 5.2
BuildRequires: python3-module-os-resource-classes >= 1.1.0
BuildRequires: python3-module-os-traits >= 2.9.0
BuildRequires: python3-module-os-vif >= 3.1.0
BuildRequires: python3-module-castellan >= 0.16.0
BuildRequires: python3-module-microversion-parse >= 0.2.1
BuildRequires: python3-module-tooz >= 1.58.0
BuildRequires: python3-module-cursive >= 0.2.1
BuildRequires: python3-module-retrying >= 1.3.3
BuildRequires: python3-module-os-service-types >= 1.7.0
BuildRequires: python3-module-dateutil >= 2.7.0
BuildRequires: python3-module-futurist >= 1.8.0
BuildRequires: python3-module-openstacksdk >= 0.35.0
BuildRequires: python3-module-yaml >= 5.1
BuildRequires: python3-module-packaging >= 21.0

%if_with tests
BuildRequires: python3-module-hacking >= 3.1.0 BuildRequires: python3-module-hacking < 3.2.0
BuildRequires: python3-module-mypy >= 0.761
BuildRequires: python3-module-types-paramiko >= 0.1.3
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-ddt >= 1.2.1
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-psycopg2-binary >= 2.8
BuildRequires: python3-module-PyMySQL >= 0.8.0
BuildRequires: python3-module-python-barbicanclient >= 4.5.2
BuildRequires: python3-module-python-ironicclient >= 3.0.0
BuildRequires: python3-module-requests-mock >= 1.2.0
BuildRequires: python3-module-oslotest >= 3.8.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-osprofiler >= 1.4.0
BuildRequires: python3-module-testresources >= 2.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.5.0
BuildRequires: python3-module-bandit >= 1.1.0
BuildRequires: python3-module-gabbi >= 1.35.0
BuildRequires: python3-module-wsgi-intercept >= 1.7.0
%endif

%if_with doc
# Required to build module documents
BuildRequires: python3-module-sphinx >= 1.6.2
BuildRequires: python3-module-sphinxcontrib-actdiag >= 0.8.5
BuildRequires: python3-module-sphinxcontrib-seqdiag >= 0.8.4
BuildRequires: python3-module-sphinx-feature-classification >= 0.2.0
BuildRequires: python3-module-os-api-ref >= 1.4.0
BuildRequires: python3-module-openstackdocstheme >= 1.19.0
BuildRequires: python3-module-reno >= 2.5.0
%endif

Requires: %name-compute = %EVR
Requires: %name-scheduler = %EVR
Requires: %name-api = %EVR
#Requires: %name-network = %EVR
Requires: %name-conductor = %EVR
#Requires: %name-console = %EVR
#Requires: %name-cells = %EVR
Requires: %name-novncproxy = %EVR

%description
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

%package common
Summary: Components common to all OpenStack Nova services
Group: System/Servers

Requires: python3-module-nova = %EVR
Requires: python3-module-oslo.rootwrap >= 5.8.0
Requires: python3-module-oslo.messaging >= 7.0.0
Requires(pre): shadow-utils

%description common
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains scripts, config and dependencies shared
between all the OpenStack nova services.

%package compute
Summary: OpenStack Nova Virtual Machine control service
Group: System/Servers

Requires: openstack-nova-common = %EVR
Requires: curl
Requires: open-iscsi
Requires: iptables iptables-ipv6
Requires: ipmitool
Requires: python3-module-libvirt libvirt-kvm
Requires: openssh-clients
Requires: rsync
Requires: lvm2
Requires: python3-module-cinderclient
Requires(pre): qemu-kvm
Requires: genisoimage
Requires: bridge-utils
Requires: sysfsutils
Requires: guestfs-data python3-module-libguestfs libguestfs-tools
Requires: polkit

%description compute
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains the Nova service for controlling Virtual Machines.

%package scheduler
Summary: OpenStack Nova VM distribution service
Group: System/Servers

Requires: openstack-nova-common = %EVR

%description scheduler
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains the service for scheduling where
to run Virtual Machines in the cloud.

%package api
Summary: OpenStack Nova API services
Group: System/Servers

Requires: openstack-nova-common = %EVR

%description api
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains the Nova services providing programmatic access.

%package conductor
Summary: OpenStack Nova Conductor services
Group: System/Servers

Requires: openstack-nova-common = %EVR

%description conductor
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains the Nova services providing database access for
the compute service

%package novncproxy
Summary: OpenStack Nova noVNC proxy service
Group: System/Servers

Requires: openstack-nova-common = %EVR
Requires: novnc
Requires: python3-module-websockify >= 0.8.0

%description novncproxy
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains the Nova noVNC Proxy service that can proxy
VNC traffic over browser websockets connections.

%package spicehtml5proxy
Summary: OpenStack Nova Spice HTML5 console access service
Group: System/Servers

Requires: openstack-nova-common = %EVR
Requires: python3-module-websockify >= 0.8.0
Requires: spice-html5

%description spicehtml5proxy
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains the Nova services providing the
spice HTML5 console access service to Virtual Machines.

%package serialproxy
Summary: OpenStack Nova serial console access service
Group: System/Servers

Requires: openstack-nova-common = %EVR
Requires: python3-module-websockify >= 0.8.0

%description serialproxy
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform. It gives you the
software, control panels, and APIs required to orchestrate a cloud,
including running instances, managing networks, and controlling access
through users and projects. OpenStack Compute strives to be both
hardware and hypervisor agnostic, currently supporting a variety of
standard hardware configurations and seven major hypervisors.

This package contains the Nova services providing the
serial console access service to Virtual Machines.

%package -n python3-module-%oname
Summary: Nova Python3 libraries
Group: Development/Python3

Requires: openssl
# Require openssh for ssh-keygen
Requires: openssh-common
Requires: sudo

Requires: python3-module-oslo.vmware >= 4.1.0 python3-module-oslo.vmware <= 4.1.1
Requires: python3-module-pbr >= 5.8.0
Requires: python3-module-sqlalchemy >= 1.4.13
Requires: python3-module-decorator >= 4.1.0
Requires: python3-module-eventlet >= 0.30.1
Requires: python3-module-jinja2 >= 2.10
Requires: python3-module-keystonemiddleware = 10.2.0
Requires: python3-module-lxml >= 4.5.0
Requires: python3-module-routes >= 2.3.1
Requires: python3-module-cryptography >= 2.7
Requires: python3-module-webob >= 1.8.2
Requires: python3-module-greenlet >= 0.4.15
Requires: python3-module-PasteDeploy >= 1.5.0
Requires: python3-module-paste >= 2.0.2
Requires: python3-module-prettytable >= 0.7.1
Requires: python3-module-migrate >= 0.13.0
Requires: python3-module-alembic >= 1.5.0
Requires: python3-module-netaddr >= 0.7.18
Requires: python3-module-netifaces >= 0.10.4
Requires: python3-module-paramiko >= 2.7.1
Requires: python3-module-iso8601 >= 0.1.11
Requires: python3-module-jsonschema >= 3.2.0
Requires: python3-module-cinderclient >= 9.2.0 python3-module-cinderclient <= 9.3.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-neutronclient >= 8.2.0 python3-module-neutronclient <= 9.0.0
Requires: python3-module-glanceclient >= 4.2.0 python3-module-glanceclient <= 4.3.0
Requires: python3-module-requests >= 2.25.1
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-websockify >= 0.9.0
Requires: python3-module-oslo.cache >= 3.3.0 python3-module-oslo.cache <= 3.3.1
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.limit = 2.1.0
Requires: python3-module-oslo.reports = 3.0.0
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.rootwrap >= 7.0.0 python3-module-oslo.rootwrap <= 7.0.1
Requires: python3-module-oslo.messaging >= 14.1.0 python3-module-oslo.messaging <= 14.2.2
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.privsep = 3.1.0
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.service >= 3.1.0 python3-module-oslo.service <= 3.1.1
Requires: python3-module-rfc3986 >= 1.2.0
Requires: python3-module-oslo.middleware >= 5.1.0 python3-module-oslo.middleware <= 5.1.1
Requires: python3-module-psutil >= 3.2.2
Requires: python3-module-oslo.versionedobjects = 3.1.0
Requires: python3-module-os-brick >= 6.2.0 python3-module-os-brick <= 6.2.2
Requires: python3-module-os-resource-classes >= 1.1.0
Requires: python3-module-os-traits >= 2.9.0
Requires: python3-module-os-vif >= 3.1.0 python3-module-os-vif <= 3.1.1
Requires: python3-module-castellan = 4.1.0
Requires: python3-module-microversion-parse >= 0.2.1
Requires: python3-module-tooz >= 1.58.0
Requires: python3-module-cursive >= 0.2.1
Requires: python3-module-retrying >= 1.3.3
Requires: python3-module-os-service-types >= 1.7.0
Requires: python3-module-dateutil >= 2.7.0
Requires: python3-module-futurist >= 1.8.0
Requires: python3-module-openstacksdk >= 0.102.0 python3-module-openstacksdk <= 1.0.1
Requires: python3-module-yaml >= 5.1
Requires: python3-module-packaging >= 21.0

%description -n python3-module-%oname
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform.

This package contains the nova Python library.

%if_with tests
%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3

%description -n python3-module-%oname-tests
This package contains tests for %oname.
%endif

%package doc
Summary: Documentation for OpenStack Compute
Group: Documentation

%description doc
OpenStack Compute (codename Nova) is open source software designed to
provision and manage large networks of virtual machines, creating a
redundant and scalable cloud computing platform.

This package contains documentation files for nova.

%prep
%setup -n %oname-%version

find . \( -name .gitignore -o -name .placeholder \) -delete

find nova -name \*.py -exec sed -i '/\/usr\/bin\/env python/{d;q}' {} +

# Remove the requirements file so that pbr hooks don't add it
# to distutils requiers_dist config
rm -rf {test-,}requirements.txt tools/{pip,test}-requires

%build
export PBR_VERSION=%version
%pyproject_build

%if_with doc
export PYTHONPATH="$( pwd ):$PYTHONPATH"
sphinx-build -b man doc/source doc/build/man
sphinx-build -b html doc/source doc/build/html
# remove the sphinx-build leftovers
rm -rf doc/build/html/.{doctrees,buildinfo}
%endif

oslo-config-generator --config-file=etc/nova/nova-config-generator.conf
oslopolicy-sample-generator --config-file=etc/nova/nova-policy-generator.conf

%install
%pyproject_install

%if_with doc
mkdir -p %buildroot%_man1dir
install -p -D -m 644 doc/build/man/*.1 %buildroot%_man1dir/
%endif

# Setup directories
install -d -m 755 %buildroot%_sharedstatedir/nova
install -d -m 755 %buildroot%_sharedstatedir/nova/buckets
install -d -m 755 %buildroot%_sharedstatedir/nova/images
install -d -m 755 %buildroot%_sharedstatedir/nova/instances
install -d -m 755 %buildroot%_sharedstatedir/nova/keys
install -d -m 755 %buildroot%_sharedstatedir/nova/networks
install -d -m 755 %buildroot%_sharedstatedir/nova/tmp
install -d -m 770 %buildroot%_logdir/nova
install -d -m 750 %buildroot%_cachedir/nova

# Install config files
install -d -m 755 %buildroot%_sysconfdir/nova
install -d -m 755 %buildroot%_sysconfdir/nova/nova.conf.d
install -p -D -m 640 etc/nova/nova.conf.sample %buildroot%_sysconfdir/nova/nova.conf
install -p -D -m 640 etc/nova/logging_sample.conf %buildroot%_sysconfdir/nova/logging.conf
install -p -D -m 640 etc/nova/rootwrap.conf %buildroot%_sysconfdir/nova/
install -p -D -m 640 etc/nova/api-paste.ini %buildroot%_sysconfdir/nova/
install -p -D -m 640 etc/nova/policy.yaml.sample %buildroot%_sysconfdir/nova/policy.yaml
mkdir -p %buildroot%_sysconfdir/nova/rootwrap.d/
install -p -D -m 640 etc/nova/rootwrap.d/compute.filters %buildroot%_sysconfdir/nova/rootwrap.d/compute.filters
install -p -D -m 644 etc/nova/rootwrap.d/* %buildroot%_sysconfdir/nova/rootwrap.d/

cp nova/api/openstack/compute/rest_api_version_history.rst %buildroot%python3_sitelibdir/nova/api/openstack/compute/rest_api_version_history.rst
cp nova/db/api/alembic.ini %buildroot%python3_sitelibdir/nova/db/api/alembic.ini
cp nova/db/api/legacy_migrations/migrate.cfg %buildroot%python3_sitelibdir/nova/db/api/legacy_migrations/migrate.cfg
cp nova/db/api/legacy_migrations/README %buildroot%python3_sitelibdir/nova/db/api/legacy_migrations/README
cp -r nova/db/api/migrations %buildroot%python3_sitelibdir/nova/db/api/migrations
cp nova/db/main/alembic.ini %buildroot%python3_sitelibdir/nova/db/main/alembic.ini
cp nova/db/main/legacy_migrations/migrate.cfg %buildroot%python3_sitelibdir/nova/db/main/legacy_migrations/migrate.cfg
cp nova/db/main/legacy_migrations/README %buildroot%python3_sitelibdir/nova/db/main/legacy_migrations/README
cp -r nova/db/main/migrations %buildroot%python3_sitelibdir/nova/db/main/migrations
cp -r nova/locale %buildroot%python3_sitelibdir/nova/locale
cp -r nova/virt/hyperv/README.rst %buildroot%python3_sitelibdir/nova/virt/hyperv/README.rst
cp -r nova/virt/interfaces.template %buildroot%python3_sitelibdir/nova/virt/interfaces.template

# Install version info file
cat > %buildroot%_sysconfdir/nova/release <<EOF
[Nova]
vendor = ALTLinux
product = OpenStack Nova
package = %version
EOF

# tmpfiles
install -p -D -m 644 %SOURCE3 %buildroot%_tmpfilesdir/%name.conf

# Install initscripts for Nova services
install -p -D -m 644 %SOURCE10 %buildroot%_unitdir/%name-api.service
install -p -D -m 644 %SOURCE12 %buildroot%_unitdir/%name-compute.service
install -p -D -m 644 %SOURCE15 %buildroot%_unitdir/%name-scheduler.service
install -p -D -m 644 %SOURCE25 %buildroot%_unitdir/%name-metadata-api.service
install -p -D -m 644 %SOURCE26 %buildroot%_unitdir/%name-conductor.service
install -p -D -m 644 %SOURCE28 %buildroot%_unitdir/%name-spicehtml5proxy.service
install -p -D -m 644 %SOURCE29 %buildroot%_unitdir/%name-novncproxy.service
install -p -D -m 644 %SOURCE31 %buildroot%_unitdir/%name-serialproxy.service
install -p -D -m 644 %SOURCE32 %buildroot%_unitdir/%name-api-os-compute.service

# Install init scripts
install -p -D -m 755 %SOURCE110 %buildroot%_initdir/%name-api
install -p -D -m 755 %SOURCE112 %buildroot%_initdir/%name-compute
install -p -D -m 755 %SOURCE115 %buildroot%_initdir/%name-scheduler
install -p -D -m 755 %SOURCE125 %buildroot%_initdir/%name-metadata-api
install -p -D -m 755 %SOURCE126 %buildroot%_initdir/%name-conductor
install -p -D -m 755 %SOURCE128 %buildroot%_initdir/%name-spicehtml5proxy
install -p -D -m 755 %SOURCE129 %buildroot%_initdir/%name-novncproxy
install -p -D -m 755 %SOURCE131 %buildroot%_initdir/%name-serialproxy
install -p -D -m 755 %SOURCE132 %buildroot%_initdir/%name-api-os-compute

# Install sudoers
install -p -D -m 400 %SOURCE24 %buildroot%_sysconfdir/sudoers.d/nova

# Install logrotate
install -p -D -m 644 %SOURCE6 %buildroot%_sysconfdir/logrotate.d/openstack-nova

# Install pid directory
install -d -m 755 %buildroot%_runtimedir/nova

# Install template files
install -p -D -m 644 %SOURCE22 %buildroot%_datadir/nova/interfaces.template

# Install policy-kit rules to allow nova user to manage libvirt
install -p -D -m 644 %SOURCE23 %buildroot%_sysconfdir/polkit-1/rules.d/50-nova.rules

# Install novncproxy service options template
install -d %buildroot%_sysconfdir/sysconfig
install -p -m 0644 %SOURCE30 %buildroot%_sysconfdir/sysconfig/openstack-nova-novncproxy

# Remove unneeded in production stuff
rm -f %buildroot%_bindir/nova-debug
rm -f %buildroot%_bindir/nova-combined
rm -f %buildroot/usr/share/doc/nova/README*

### set default configuration (mostly applies to package-only setups and quickstart, i.e. not generally crowbar)
%define nova_conf %buildroot%_sysconfdir/nova/nova.conf.d/010-nova.conf
crudini --set %nova_conf DEFAULT log_dir /var/log/nova
crudini --set %nova_conf DEFAULT state_path /var/lib/nova
crudini --set %nova_conf oslo_concurrency lock_path %_runtimedir/nova

# cleanup
rm -rf %buildroot/usr/etc/nova

%pre common
# 162:162 for nova (openstack-nova)
%_sbindir/groupadd -r -g 162 -f nova 2>/dev/null ||:
%_sbindir/useradd -r -u 162 -g nova -G nova,nobody,wheel -c 'OpenStack Nova Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/nova nova 2>/dev/null ||:

%pre compute
usermod -a -G vmusers nova 2>/dev/null ||:
usermod -a -G fuse nova 2>/dev/null ||:

%post compute
%post_service %name-compute
%preun compute
%preun_service %name-compute

%post scheduler
%post_service %name-scheduler
%preun scheduler
%preun_service %name-scheduler

%post api
%post_service %name-api
%post_service %name-metadata-api
%post_service %name-api-os-compute

%preun api
%preun_service %name-api
%preun_service %name-metadata-api
%preun_service %name-api-os-compute

%post conductor
%post_service %name-conductor
%preun conductor
%preun_service %name-conductor

%post novncproxy
%post_service %name-novncproxy
%preun novncproxy
%preun_service %name-novncproxy

%post spicehtml5proxy
%post_service %name-spicehtml5proxy
%preun spicehtml5proxy
%preun_service %name-spicehtml5proxy

%post serialproxy
%post_service %name-serialproxy
%preun serialproxy
%preun_service %name-serialproxy

%files

%files common
%doc LICENSE
%dir %_sysconfdir/nova
%dir %_sysconfdir/nova/nova.conf.d
%_sysconfdir/nova/release
%config(noreplace) %attr(0640, root, nova) %_sysconfdir/nova/nova.conf
%config(noreplace) %attr(0640, root, nova) %_sysconfdir/nova/nova.conf.d/010-nova.conf
%config(noreplace) %attr(0640, root, nova) %_sysconfdir/nova/api-paste.ini
%config(noreplace) %attr(0640, root, nova) %_sysconfdir/nova/logging.conf
%config %_sysconfdir/nova/rootwrap.conf
%dir %_sysconfdir/nova/rootwrap.d
%config %attr(0640, root, nova) %_sysconfdir/nova/policy.yaml
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config(noreplace) %_sysconfdir/sudoers.d/nova
%config(noreplace) %_sysconfdir/polkit-1/rules.d/50-nova.rules

%_tmpfilesdir/%name.conf
%dir %attr(0770, root, nova) %_logdir/nova
%dir %attr(0775, root, nova) %_runtimedir/nova

%_datadir/nova
%if_with doc
%_man1dir/nova*.1.*
%endif

%defattr(-, nova, nova, -)
%dir %_sharedstatedir/nova
%dir %_sharedstatedir/nova/buckets
%dir %_sharedstatedir/nova/instances
%dir %_sharedstatedir/nova/keys
%dir %_sharedstatedir/nova/networks
%dir %_sharedstatedir/nova/tmp
%dir %_cachedir/nova

%files compute
%config %_sysconfdir/nova/rootwrap.d/compute.filters
%_unitdir/%name-compute.service
%_initdir/%name-compute

%files scheduler
%_unitdir/%name-scheduler.service
%_initdir/%name-scheduler

%files api
#%config %_sysconfdir/nova/rootwrap.d/api-metadata.filters
%_initdir/%name-api
%_initdir/%name-metadata-api
%_initdir/%name-api-os-compute
%_unitdir/%name-api.service
%_unitdir/%name-metadata-api.service
%_unitdir/%name-api-os-compute.service

%files conductor
%_unitdir/%name-conductor.service
%_initdir/%name-conductor

%files novncproxy
%_unitdir/%name-novncproxy.service
%_initdir/%name-novncproxy
%config(noreplace) %_sysconfdir/sysconfig/openstack-nova-novncproxy

%files spicehtml5proxy
%_unitdir/%name-spicehtml5proxy.service
%_initdir/%name-spicehtml5proxy

%files serialproxy
%_unitdir/%name-serialproxy.service
%_initdir/%name-serialproxy

%files -n python3-module-%oname
%doc LICENSE
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/test.*

%if_with tests
%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/test.*
%endif

%if_with doc
%files doc
%doc LICENSE doc/build/html
%endif

%changelog
