%define includedir %_includedir/%name

Name: p7zip
Version: 17.05
Release: alt2

Summary: 7zip unofficial port - a file-archiver with highest compression ratio

License: LGPLv2+ with UnRAR exception
Group: Archiving/Compression
Url: https://github.com/p7zip-project/p7zip

# Source-url: https://github.com/p7zip-project/p7zip/archive/refs/tags/v%version.tar.gz
Source: v%version.tar.gz

Patch0: p7zip-17.02-P7ZIP_HOME_DIR.patch
Patch1: p7zip-17.05-ZIP_STRING_LENGTH.patch
Patch2: p7zip-17.05-MAX_LEVEL_ZSTD.patch

# Automatically added by buildreq on Sat Oct 08 2011
# optimized out: libstdc++-devel
BuildRequires: gcc-c++ /proc
%ifarch %ix86
BuildRequires: nasm
%endif
%ifarch x86_64
BuildRequires: yasm
%endif

%description
p7zip is a port of 7-Zip for Unix. 7-Zip is a file archiver
with a very high compression ratio.

%package standalone
Summary: Standalone p7zip executable without plugins
Group: Archiving/Compression
License: LGPLv2.1+
Requires: p7zip

%description standalone
p7zip is a port of 7-Zip for Unix. 7-Zip is a file archiver
with a very high compression ratio.

This package contains standalone version of p7zip.
It handles less archive formats than plugin capable version.

%package devel
Summary: Development package of p7zip that includes the header files
Group: Development/C
License: Public domain
BuildArch: noarch

Requires: %name = %EVR

%description devel
The devel package contains the p7zip include files.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
chmod +x *.sh */*.sh

%build
%ifarch %e2k
# _LITTLE_ENDIAN gets defined but not checked for
%add_optflags -D__LITTLE_ENDIAN__
# -ffast is faster but its -floop-apb-conditional-loads is potentially dangerous
%add_optflags -fcache-opt
%endif

%ifarch %ix86
cp -f makefile.linux_x86_asm_gcc_4.X makefile.machine
%endif
%ifarch x86_64
cp -f makefile.linux_amd64_asm makefile.machine
%endif
%ifarch %ix86 %mips32
sed -i 's/mx=2[12]/mx=9/' check/check.sh check/check_7za.sh
%endif

# NB: 'all' is not default target in this makefile
%add_optflags -DP7ZIP_HOME_DIR='\"%_libdir/p7zip/\"'
%make_build OPTFLAGS="%optflags" all2

# NB: Someday I probably should build and package 7zG (7z GUI), but for now
# this GUI is far from useful.

%install
./install.sh %_bindir %_libdir/p7zip %_mandir %_docdir/%name-%version %buildroot
# Install script put shell wrappers in /usr/bin/ instead of executables.
# We don't want this, see comments to inline patch above to get idea of our way.
mv -f %buildroot%_libdir/p7zip/{7z,7za} %buildroot%_bindir/

# Install C/*.h files
mkdir -p %buildroot%includedir
find C -maxdepth 1 -mindepth 1 -name '*.h' -a -not \( -name Threads.h -o -name LzFindMt.h -o -name MtCoder.h \) -print0 | \
xargs -0 install -pm644 -t %buildroot%includedir/

%files
%doc README ChangeLog DOC
%_bindir/7z
%dir %_libdir/p7zip
%_libdir/p7zip/*.so
%_libdir/p7zip/*.sfx
%_libdir/p7zip/Codecs
%_man1dir/7z.*
%exclude %_man1dir/7zr.*

%files standalone
%_bindir/7za
%_man1dir/7za.*

%files devel
%includedir

%check
%ifnarch %ix86
P7ZIP_HOME_DIR=`pwd`/bin/ make test_7z
%endif

%changelog
