Name: pam_userpass
Version: 1.0.2
Release: alt6

Summary: Pluggable authentication module for USER/PASS-style protocols
License: LGPLv2+
Group: System/Base
Url: http://www.openwall.com/pam/

# ftp://ftp.openwall.com/pub/projects/pam/modules/pam_userpass/pam_userpass-%version.tar.gz
Source: pam_userpass-%version.tar

# due to PAM policy.
BuildRequires(pre): libpam0-devel
# due to change in format of PAM modules requirements.
BuildRequires: rpm-build >= 0:4.0.4-alt55

%set_pam_name %name

%package -n %pam_name
Summary: Pluggable authentication module for USER/PASS-style protocols
Group: System/Base
Provides: %name = %version-%release
Obsoletes: %name < %version-%release

%package devel
Summary: Library and header files for developing pam_userpass-aware applications
Group: Development/C
Requires: %pam_name = %version-%release, libpam-devel

%package devel-static
Summary: Development static pam_userpass library
Group: Development/C
Requires: %name-devel = %version-%release

%description
pam_userpass is a PAM authentication module for use specifically by
services implementing non-interactive protocols and wishing
to verify a username/password pair.  The module doesn't do
any actual authentication, - other modules, such as pam_tcb,
should be stacked to provide the authentication.

%description -n %pam_name
pam_userpass is a PAM authentication module for use specifically by
services implementing non-interactive protocols and wishing
to verify a username/password pair.  The module doesn't do
any actual authentication, - other modules, such as pam_tcb,
should be stacked to provide the authentication.

%description devel
pam_userpass is a PAM authentication module for use specifically by
services implementing non-interactive protocols and wishing
to verify a username/password pair.  The module doesn't do
any actual authentication, - other modules, such as pam_tcb,
should be stacked to provide the authentication.

This package contains development library and header files
required for building pam_userpass-aware applications.

%description devel-static
pam_userpass is a PAM authentication module for use specifically by
services implementing non-interactive protocols and wishing
to verify a username/password pair.  The module doesn't do
any actual authentication, - other modules, such as pam_tcb,
should be stacked to provide the authentication.

This package contains development static library.

%prep
%setup

%build
%make_build \
	CFLAGS="%optflags %optflags_shared -Iinclude" \
	SECUREDIR=/%_lib/security \
	LIBDIR=%_libdir \
	LDFLAGS= \
	#

%install
%makeinstall_std \
	SECUREDIR=/%_lib/security \
	LIBDIR=%_libdir \
	#

%define docdir %_docdir/%name-%version

rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir/example
install -p -m644 LICENSE README %buildroot%docdir/
install -p -m644 example_userpass.c \
	%buildroot%docdir/example/
install -p -m644 conf/example_userpass \
	%buildroot%docdir/example/example_userpass.pamd

%files -n %pam_name
%_libdir/*.so.*
/%_lib/security/*
%dir %docdir
%docdir/[A-Z]*

%files devel
%_libdir/*.so
%_includedir/security/*
%dir %docdir
%docdir/example

%files devel-static
%_libdir/*.a

%changelog
