Name: patch
Version: 2.7.6.0.27.7623
Release: alt1

Summary: The GNU patch command, for modifying/upgrading files
License: GPLv3+
Group: Text tools
Url: https://www.gnu.org/software/patch/
Vcs: git://git.altlinux.org/gears/p/patch.git
Source: %name-%version-%release.tar

BuildRequires: gnulib >= 0.1.4078.702cb

# for extended attribute copying support
BuildRequires: libattr-devel

# Note that patch --ed required ed(1).
%{?!_without_check:%{?!_disable_check:BuildRequires: ed}}

%description
The patch program applies diff files to originals.  The diff command
is used to compare an original to a changed file.  Diff lists the
changes made to the file.  A person who has the original file can then
use the patch command with the diff file to add the changes to their
original file (patching the file).

%prep
%setup -n %name-%version-%release
echo -n %version > .tarball-version

%build
./bootstrap --skip-po --gnulib-srcdir=%_datadir/gnulib
# Since patch is not a threaded executable,
# configure gnulib with --disable-threads.
# This is not just a harmless optimization that saves a few cycles
# but also a workaround that fixes GNU ld errors on ppc64le reported by
# eu-elflint --gnu-ld /usr/bin/patch
%configure --disable-silent-rules --disable-threads
%make_build

%install
%makeinstall_std

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
%make_build -k check VERBOSE=1

%files
%_bindir/*
%_man1dir/*
%doc AUTHORS NEWS README

%changelog
