%def_enable static
%{?_enable_static:%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}}
%def_enable check

Name: pcre2
Version: 10.42
Release: alt1

Summary: Perl-compatible regular expression library
Group: System/Libraries
License: BSD-style
Url: http://www.pcre.org/

Vcs: https://github.com/PCRE2Project/pcre2.git
Source: https://github.com/PCRE2Project/%name/releases/download/%name-%version/%name-%version.tar.gz
#Source: https://ftp.pcre.org/pub/pcre/%name-%version.tar.gz

BuildRequires: libreadline-devel zlib-devel bzlib-devel

%description
PCRE2 is a re-working of the original PCRE (Perl-compatible regular
expression) library to provide an entirely new API.

PCRE2 is written in C, and it has its own API. There are three sets of
functions, one for the 8-bit library, which processes strings of bytes, one
for the 16-bit library, which processes strings of 16-bit values, and one for
the 32-bit library, which processes strings of 32-bit values. There are no C++
wrappers.

%package -n lib%name
Summary: %summary
Group: System/Libraries

%description -n lib%name
PCRE2 is a re-working of the original PCRE (Perl-compatible regular
expression) library to provide an entirely new API.

This package provides shared perl-compatible regular expression libraries.

%package -n lib%name-devel
Summary: Development files for PCRE2 libraries
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides development files for PCRE2 libraries.

%package -n lib%name-devel-static
Summary: Static PCRE2 libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package provides static versions of PCRE2 libraries.

%package tools
Summary: Auxiliary utilities for %name
Group: Development/Tools
Requires: lib%name = %version-%release

%description tools
Utilities demonstrating PCRE2 capabilities like pcre2grep or pcre2test.

%prep
%setup -n %name-%version

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
%ifnarch %e2k riscv64
    --enable-jit \
    --enable-pcre2grep-jit \
%endif
    --disable-bsr-anycrlf \
    --disable-coverage \
    --disable-ebcdic \
    --enable-newline-is-lf \
    --enable-pcre2-8 \
    --enable-pcre2-16 \
    --enable-pcre2-32 \
    --disable-pcre2test-libedit \
    --enable-pcre2test-libreadline \
    --enable-pcre2grep-libbz2 \
    --enable-pcre2grep-libz \
    --disable-rebuild-chartables \
    --enable-shared \
    --enable-stack-for-recursion \
    --enable-unicode \
    --disable-valgrind \
    %{subst_enable static}
%nil
%make_build

%install
%makeinstall_std

# relocate shared libraries to /%_lib for journalctl
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/lib%name-{8,16,32,posix}.so; do
	if t=$(readlink "$f"); then
		ln -sf ../../%_lib/"$t" "$f"
	fi
done

mv %buildroot%_libdir/lib%name-{8,16,32,posix}.so.* %buildroot/%_lib/

%check
%make check

%files -n lib%name
/%_lib/lib%name-16.so.*
/%_lib/lib%name-32.so.*
/%_lib/lib%name-8.so.*
/%_lib/lib%name-posix.so.*
%doc LICENCE AUTHORS ChangeLog NEWS README

%files -n lib%name-devel
%_bindir/%name-config
%_includedir/*.h
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man1dir/%name-config.1.*
%_man3dir/*
%doc doc/html
%doc HACKING ./src/%{name}demo.c

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files tools
%_bindir/%{name}grep
%_bindir/%{name}test
%_man1dir/%{name}grep.1.*
%_man1dir/%{name}test.1.*

%exclude %_docdir/%name

%changelog
